/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import pt.com.broker.client.nio.consumer.ConsumerManager;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;

@ChannelHandler.Sharable
public class ReceiveFaultHandler
extends SimpleChannelInboundHandler<NetMessage> {
    private ConsumerManager manager;
    private BrokerListener faultListenerAdapter;

    public ReceiveFaultHandler(ConsumerManager manager) {
        this.manager = manager;
    }

    public ConsumerManager getManager() {
        return this.manager;
    }

    protected void channelRead0(ChannelHandlerContext ctx, NetMessage msg) throws Exception {
        NetFault fault = msg.getAction().getFaultMessage();
        if (fault == null) {
            ctx.fireChannelRead((Object)msg);
            return;
        }
        try {
            this.deliverFaultMessage(ctx, msg);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    protected void deliverFaultMessage(ChannelHandlerContext ctx, NetMessage msg) throws Throwable {
        NetFault fault = msg.getAction().getFaultMessage();
        ChannelDecorator decorator = new ChannelDecorator(ctx.channel());
        if (fault.getCode().equals("2005") || fault.getCode().equals("2006")) {
            this.getManager().deliverMessage(msg, decorator.getHost());
            return;
        }
        BrokerListener listener = this.getFaultListenerAdapter();
        if (listener != null) {
            this.getFaultListenerAdapter().deliverMessage(msg, decorator.getHost());
            return;
        }
        ctx.fireChannelRead((Object)msg);
    }

    public BrokerListener getFaultListenerAdapter() {
        return this.faultListenerAdapter;
    }

    public void setFaultListenerAdapter(BrokerListener faultListenerAdapter) {
        this.faultListenerAdapter = faultListenerAdapter;
    }
}

