/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.bootstrap.BaseBootstrap;
import pt.com.broker.client.nio.events.connection.ConnectionEventListener;
import pt.com.broker.client.nio.events.connection.ConnectionStatusChangeEventImpl;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.server.ReconnectEvent;
import pt.com.broker.client.nio.server.strategies.RoundRobinStrategy;
import pt.com.broker.client.nio.server.strategies.SelectServerStrategy;
import pt.com.broker.client.nio.utils.ChannelDecorator;

public class HostContainer
extends Observable {
    private static final Logger log = LoggerFactory.getLogger(HostContainer.class);
    private static final Object channelLocker = new Object();
    private List<HostInfo> hosts;
    private List<HostInfo> connectedHosts;
    private BaseBootstrap bootstrap;
    ExecutorService executorService = Executors.newFixedThreadPool(10);
    ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final CompletionService<HostInfo> service = new ExecutorCompletionService<HostInfo>(this.executorService);
    SelectServerStrategy strategy = new RoundRobinStrategy();
    private List<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>();

    public HostContainer(BaseBootstrap bootstrap) {
        this(1, bootstrap);
    }

    public HostContainer(int capacity, BaseBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.hosts = new ArrayList<HostInfo>(capacity);
        this.connectedHosts = new ArrayList<HostInfo>(capacity);
        this.strategy.setCollection(this.connectedHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(HostInfo host) {
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            if (this.hosts.contains(host)) {
                throw new RuntimeException("Cannot add server twice");
            }
            this.hosts.add(host);
        }
    }

    public int size() {
        return this.hosts.size();
    }

    public HostInfo connect() {
        Future<HostInfo> f = this.connectAsync();
        try {
            HostInfo host = f.get();
            return host;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not connect", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<HostInfo> connectAsync() {
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            ArrayList<HostInfo> hosts = this.getClosedHosts();
            if (hosts.size() == 0) {
                throw new RuntimeException("There are no available hosts to connect");
            }
            Future<HostInfo> f = this.connect(hosts);
            return f;
        }
    }

    private Future<HostInfo> connect(final Collection<HostInfo> servers) {
        return this.executorService.submit(new Callable<HostInfo>(){

            @Override
            public HostInfo call() throws Exception {
                for (final HostInfo host : servers) {
                    HostContainer.this.service.submit(new Callable<HostInfo>(){

                        @Override
                        public HostInfo call() throws Exception {
                            ChannelFuture f = HostContainer.this.connectToHost(host);
                            final CountDownLatch latch = new CountDownLatch(1);
                            f.addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    latch.countDown();
                                    future.channel().pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(host, HostInfo.STATUS.OPEN));
                                }
                            });
                            latch.await();
                            return host;
                        }
                    });
                }
                HostInfo host = null;
                int count = servers.size();
                while (!((host = (HostInfo)HostContainer.this.service.take().get()) != null && host.isActive() || --count <= 0)) {
                }
                if (host == null) {
                    throw new Exception("Could not connect");
                }
                while (!host.isActive()) {
                    Thread.sleep(500L);
                }
                for (ConnectionEventListener eventListener : HostContainer.this.connectionEventListeners) {
                    eventListener.connected(host);
                }
                return host;
            }
        });
    }

    private void reconnect(final HostInfo host) {
        if (!this.scheduler.isShutdown() && !this.bootstrap.getGroup().isShuttingDown()) {
            final HostContainer hostContainer = this;
            this.scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        HostContainer.this.connectToHost(host).addListener((GenericFutureListener)new ChannelFutureListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    return;
                                }
                                HostContainer hostContainer = hostContainer;
                                synchronized (hostContainer) {
                                    hostContainer.setChanged();
                                    hostContainer.notifyObservers(new ReconnectEvent(host));
                                    log.debug("Fire the user event trigger RECONNECT!");
                                    future.channel().pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(host, HostInfo.STATUS.OPEN));
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        log.error("Unexpected error caught.", (Throwable)e);
                    }
                }
            }, 2000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HostInfo> getClosedHosts() {
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            ArrayList<HostInfo> list2 = new ArrayList<HostInfo>(0);
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo host;
                HostInfo hostInfo = host = iterator.next();
                synchronized (hostInfo) {
                    if (host.getStatus() == HostInfo.STATUS.CLOSED) {
                        list2.add(host);
                    }
                }
            }
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HostInfo> notConnectedHosts() {
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            ArrayList<HostInfo> list2 = new ArrayList<HostInfo>(0);
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo host;
                HostInfo hostInfo = host = iterator.next();
                synchronized (hostInfo) {
                    if (host.getStatus() == HostInfo.STATUS.CLOSED || host.getStatus() == HostInfo.STATUS.CONNECTING || host.getStatus() == HostInfo.STATUS.DISABLE) {
                        list2.add(host);
                    }
                }
            }
            return list2;
        }
    }

    protected boolean isConnected(HostInfo hostInfo) {
        return hostInfo != null && hostInfo.getStatus() == HostInfo.STATUS.OPEN && this.connectedHosts.contains(hostInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HostInfo inactiveHost(HostInfo host) {
        if (host != null) {
            List<HostInfo> list = this.connectedHosts;
            synchronized (list) {
                if (!this.connectedHosts.remove(host)) {
                    throw new RuntimeException("invalid host removed");
                }
                log.debug("Connection closed: " + host);
            }
        }
        return host;
    }

    public HostInfo getAvailableHost() {
        HostInfo host = null;
        int total = this.connectedHosts.size();
        if (total == 0) {
            return null;
        }
        do {
            if ((host = this.strategy.next()) != null || total-- >= 1 || (total = this.connectedHosts.size()) != 0) continue;
            return null;
        } while (host == null || host != null && !host.getChannel().isOpen());
        return host;
    }

    public Future disconnect() {
        return this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = HostContainer.this.hosts;
                synchronized (list) {
                    for (HostInfo host : HostContainer.this.hosts) {
                        try {
                            HostInfo hostInfo = host;
                            synchronized (hostInfo) {
                                if (host.getChannel() != null) {
                                    HostContainer.this.disconnect(host).get();
                                }
                                host.setStatus(HostInfo.STATUS.DISABLE);
                            }
                        }
                        catch (Throwable e) {
                            log.error("Error disconnecting", e);
                        }
                    }
                }
            }
        });
    }

    public ChannelFuture disconnect(HostInfo host) {
        if (host.getStatus() == HostInfo.STATUS.DISABLE) {
            throw new RuntimeException("Server already disconnected");
        }
        Channel channel = host.getChannel();
        host.setChannel(null);
        ChannelFuture f = channel.disconnect();
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                log.debug("Server disconnected");
            }
        });
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture connectToHost(final HostInfo host) throws Exception {
        HostInfo hostInfo = host;
        synchronized (hostInfo) {
            if (host.getStatus() != HostInfo.STATUS.CLOSED) {
                throw new RuntimeException("Cannot open an host that is not closed");
            }
            host.setStatus(HostInfo.STATUS.CONNECTING);
            final ChannelFuture f = this.bootstrap.connect(host);
            f.addListener((GenericFutureListener)new ChannelFutureListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(ChannelFuture future) throws Exception {
                    HostInfo hostInfo = host;
                    synchronized (hostInfo) {
                        if (!future.isSuccess()) {
                            host.reconnectAttempt();
                            log.debug("Error connecting to server: " + host);
                            HostContainer.this.reconnect(host);
                            return;
                        }
                        ChannelDecorator channel = new ChannelDecorator(f.channel());
                        host.resetReconnectLimit();
                        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                HostContainer.this.inactiveHost(host);
                                future.channel().pipeline().fireUserEventTriggered((Object)new ConnectionStatusChangeEventImpl(host, HostInfo.STATUS.DISABLE));
                                if (!future.isCancelled()) {
                                    HostContainer.this.reconnect(host);
                                }
                            }
                        });
                        HostContainer.this.addConnectedHost(host);
                        log.debug("Connected to server: " + host);
                    }
                }
            });
            return f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnectedHost(HostInfo host) throws Exception {
        if (host == null) {
            throw new Exception("Invalid host");
        }
        List<HostInfo> list = this.connectedHosts;
        synchronized (list) {
            if (this.connectedHosts.contains(host)) {
                throw new RuntimeException("Cannot add connected server twice");
            }
            this.connectedHosts.add(host);
        }
    }

    public Collection<HostInfo> getConnectedHosts() {
        return this.connectedHosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostsSize() {
        List<HostInfo> list = this.hosts;
        synchronized (list) {
            return this.hosts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectedSize() {
        List<HostInfo> list = this.connectedHosts;
        synchronized (list) {
            return this.connectedHosts.size();
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.executorService.shutdown();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }
}

