/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.types;

import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;

public class DestinationDataDelegator {
    NetMessage netMessage;

    public DestinationDataDelegator(NetMessage msg) {
        this.netMessage = msg;
    }

    public String getSubscription() {
        NetAction netAction = this.netMessage.getAction();
        NetAction.ActionType actionType = netAction.getActionType();
        String destination = null;
        switch (actionType) {
            case NOTIFICATION: {
                destination = netAction.getNotificationMessage().getSubscription();
                break;
            }
            case FAULT: {
                destination = this.getDestination(this.netMessage.getAction().getFaultMessage());
            }
        }
        return destination;
    }

    public String getDestination() {
        NetAction netAction = this.netMessage.getAction();
        NetAction.ActionType actionType = netAction.getActionType();
        String destination = null;
        switch (actionType) {
            case NOTIFICATION: {
                destination = netAction.getNotificationMessage().getDestination();
                break;
            }
            case FAULT: {
                destination = this.getDestination(netAction.getFaultMessage());
            }
        }
        return destination;
    }

    public NetAction.DestinationType getDestinationType() {
        NetAction netAction = this.netMessage.getAction();
        NetAction.ActionType actionType = netAction.getActionType();
        NetAction.DestinationType destinationType = null;
        switch (actionType) {
            case NOTIFICATION: {
                destinationType = netAction.getNotificationMessage().getDestinationType();
                break;
            }
            case FAULT: {
                destinationType = this.getDestinationType(netAction.getFaultMessage());
            }
        }
        return destinationType;
    }

    protected String getDestination(NetFault fault) {
        if ("2005".equals(fault.getCode()) || "2006".equals(fault.getCode())) {
            return fault.getDetail();
        }
        return null;
    }

    protected NetAction.DestinationType getDestinationType(NetFault fault) {
        if ("2005".equals(fault.getCode())) {
            return NetAction.DestinationType.QUEUE;
        }
        return null;
    }
}

