/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.UUID;
import org.junit.Test;
import org.mockito.Mockito;
import pt.com.broker.client.nio.consumer.PendingAcceptRequestsManager;
import pt.com.broker.client.nio.events.AcceptResponseListener;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.handlers.AcceptMessageHandler;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;

public class TestAcceptResponseListener {
    @Test
    public void testAcceptListener() throws Throwable {
        PendingAcceptRequestsManager manager = new PendingAcceptRequestsManager();
        AcceptResponseListener listener = (AcceptResponseListener)Mockito.mock(AcceptResponseListener.class);
        AcceptMessageHandler acceptMessageHandler = new AcceptMessageHandler(manager);
        NetAccepted netAccepted = new NetAccepted(UUID.randomUUID().toString());
        manager.addAcceptRequest(netAccepted.getActionId(), 2000L, (BrokerListener)listener);
        NetMessage netMessage = new NetMessage(new NetAction(netAccepted));
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{acceptMessageHandler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        channel.writeInbound(new Object[]{netMessage});
        ((AcceptResponseListener)Mockito.verify((Object)listener)).deliverMessage(netMessage, host);
        ((AcceptResponseListener)Mockito.verify((Object)listener)).onMessage(netAccepted, host);
    }

    @Test
    public void testAcceptListenerTimeout() throws Throwable {
        PendingAcceptRequestsManager manager = new PendingAcceptRequestsManager();
        AcceptResponseListener listener = (AcceptResponseListener)Mockito.mock(AcceptResponseListener.class);
        NetAccepted netAccepted = new NetAccepted(UUID.randomUUID().toString());
        manager.addAcceptRequest(netAccepted.getActionId(), 2000L, (BrokerListener)listener);
        Thread.sleep(3000L);
        ((AcceptResponseListener)Mockito.verify((Object)listener)).onTimeout(netAccepted.getActionId());
    }

    @Test
    public void testAcceptListenerFault() throws Throwable {
        PendingAcceptRequestsManager manager = new PendingAcceptRequestsManager();
        AcceptResponseListener listener = (AcceptResponseListener)Mockito.mock(AcceptResponseListener.class);
        AcceptMessageHandler acceptMessageHandler = new AcceptMessageHandler(manager);
        String actionId = UUID.randomUUID().toString();
        NetFault fault = NetFault.AccessDeniedErrorMessage.getAction().getFaultMessage();
        fault.setActionId(actionId);
        manager.addAcceptRequest(actionId, 2000L, (BrokerListener)listener);
        NetMessage netMessage = new NetMessage(new NetAction(fault));
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{acceptMessageHandler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        channel.writeInbound(new Object[]{netMessage});
        ((AcceptResponseListener)Mockito.verify((Object)listener)).deliverMessage(netMessage, host);
        ((AcceptResponseListener)Mockito.verify((Object)listener)).onFault(fault, host);
    }
}

