/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import pt.com.broker.client.nio.consumer.ConsumerManager;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.ErrorListenerAdapter;
import pt.com.broker.client.nio.handlers.ReceiveFaultHandler;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;

@RunWith(value=MockitoJUnitRunner.class)
public class TestErrorListener {
    @Mock
    ErrorListenerAdapter mockListener;
    @Mock
    ConsumerManager consumerManager;

    @Test
    public void testHandlerCall() throws Throwable {
        ReceiveFaultHandler handler = new ReceiveFaultHandler(this.consumerManager);
        handler.setFaultListenerAdapter((BrokerListener)this.mockListener);
        NetMessage error = NetFault.AccessDeniedErrorMessage;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        channel.writeInbound(new Object[]{error});
        ((ErrorListenerAdapter)Mockito.verify((Object)this.mockListener, (VerificationMode)Mockito.times((int)1))).deliverMessage(error, host);
        ((ErrorListenerAdapter)Mockito.verify((Object)this.mockListener, (VerificationMode)Mockito.times((int)1))).onMessage(error.getAction().getFaultMessage(), host);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.consumerManager});
    }

    @Test
    public void testHandlerPollFaults() throws Throwable {
        ReceiveFaultHandler handler = new ReceiveFaultHandler(this.consumerManager);
        handler.setFaultListenerAdapter((BrokerListener)this.mockListener);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        NetMessage error = NetFault.PollTimeoutErrorMessage;
        channel.writeInbound(new Object[]{error});
        NetMessage error2 = NetFault.NoMessageInQueueErrorMessage;
        channel.writeInbound(new Object[]{error2});
        ((ConsumerManager)Mockito.verify((Object)this.consumerManager, (VerificationMode)Mockito.times((int)1))).deliverMessage(error, host);
        ((ConsumerManager)Mockito.verify((Object)this.consumerManager, (VerificationMode)Mockito.times((int)1))).deliverMessage(error2, host);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockListener});
    }
}

