/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.listener;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.UUID;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import pt.com.broker.client.nio.consumer.PongConsumerManager;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.PongListenerAdapter;
import pt.com.broker.client.nio.handlers.PongMessageHandler;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetPong;

@RunWith(value=MockitoJUnitRunner.class)
public class TestPongListener {
    @Mock
    PongListenerAdapter pongListenerAdapter;

    @Test
    public void testHandlerCallPublic() throws Throwable {
        PongConsumerManager pongConsumerManager = new PongConsumerManager();
        PongMessageHandler pongMessageHandler = new PongMessageHandler(pongConsumerManager);
        String actionId = UUID.randomUUID().toString();
        pongConsumerManager.addSubscription(actionId, (BrokerListener)this.pongListenerAdapter);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{pongMessageHandler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        NetMessage message = this.createPong(actionId);
        channel.writeInbound(new Object[]{message});
        ((PongListenerAdapter)Mockito.verify((Object)this.pongListenerAdapter, (VerificationMode)Mockito.times((int)1))).deliverMessage(message, host);
        ((PongListenerAdapter)Mockito.verify((Object)this.pongListenerAdapter, (VerificationMode)Mockito.times((int)1))).onMessage(message.getAction().getPongMessage(), host);
    }

    @Test
    public void testHeartBeatMessage() throws Throwable {
        String actionId = "24bb963d-6d6c-441e-ab4d-999d73578452";
        PongConsumerManager pongConsumerManager = new PongConsumerManager();
        PongMessageHandler pongMessageHandler = new PongMessageHandler(pongConsumerManager);
        pongConsumerManager.addSubscription(actionId, (BrokerListener)this.pongListenerAdapter);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{pongMessageHandler});
        ChannelDecorator decorator = new ChannelDecorator((Channel)channel);
        HostInfo host = new HostInfo("127.0.0.1", 3323);
        decorator.setHost(host);
        NetMessage message = this.createPong(actionId);
        channel.writeInbound(new Object[]{message});
        ((PongListenerAdapter)Mockito.verify((Object)this.pongListenerAdapter, (VerificationMode)Mockito.never())).deliverMessage(message, host);
        ((PongListenerAdapter)Mockito.verify((Object)this.pongListenerAdapter, (VerificationMode)Mockito.never())).onMessage(message.getAction().getPongMessage(), host);
    }

    protected NetMessage createPong(String actionId) {
        return new NetMessage(new NetAction(new NetPong(actionId)));
    }

    @Test
    public void testPongConsumerInvalidActionId() {
        String actionId = UUID.randomUUID().toString();
        PongConsumerManager pongConsumerManager = new PongConsumerManager();
        PongMessageHandler pongMessageHandler = new PongMessageHandler(pongConsumerManager);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{pongMessageHandler});
        NetMessage message = this.createPong(actionId);
        channel.writeInbound(new Object[]{message});
    }
}

