/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.mocks;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.codecs.BindingSerializerFactory;
import pt.com.broker.client.nio.codecs.BrokerMessageDecoder;
import pt.com.broker.client.nio.codecs.BrokerMessageEncoder;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetPong;
import pt.com.broker.types.NetProtocolType;

public class SocketServer {
    private static final Logger log = LoggerFactory.getLogger(SocketServer.class);
    int port;
    private ChannelFuture future;
    EventLoopGroup bossGroup = new NioEventLoopGroup();
    EventLoopGroup workerGroup = new NioEventLoopGroup();
    ServerBootstrap b = new ServerBootstrap();

    public SocketServer() {
        this(0);
    }

    public SocketServer(int port) {
        this.port = port;
    }

    protected int bind() throws Exception {
        ChannelFuture future = this.run();
        this.setFuture(future);
        InetSocketAddress address = (InetSocketAddress)future.channel().localAddress();
        this.port = address.getPort();
        log.debug("Test server running on port: " + this.getPort());
        return this.getPort();
    }

    private ChannelFuture run() throws Exception {
        ((ServerBootstrap)((ServerBootstrap)this.b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                BindingSerializer binding = BindingSerializerFactory.getInstance((NetProtocolType)NetProtocolType.JSON);
                ch.pipeline().addLast("broker_message_decoder", (ChannelHandler)new BrokerMessageDecoder(binding));
                ch.pipeline().addLast("broker_message_encoder", (ChannelHandler)new BrokerMessageEncoder(binding));
                ch.pipeline().addLast("server_handler", (ChannelHandler)new InputHandler());
                log.debug("Remote client connected");
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture f = this.b.bind("0.0.0.0", this.getPort()).sync();
        return f;
    }

    public int getPort() {
        return this.port;
    }

    private ChannelFuture getFuture() {
        return this.future;
    }

    private void setFuture(ChannelFuture future) {
        this.future = future;
    }

    public Future shutdown() {
        try {
            this.bossGroup.shutdownGracefully();
            return this.workerGroup.shutdownGracefully();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class InputHandler
    extends ChannelInboundHandlerAdapter {
        private InputHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            NetMessage _msg;
            if (msg instanceof NetMessage && (_msg = (NetMessage)msg).getAction().getActionType() == NetAction.ActionType.PING) {
                NetMessage netMessage = new NetMessage(new NetAction(new NetPong(_msg.getAction().getPingMessage().getActionId())));
                ctx.writeAndFlush((Object)netMessage);
            }
            ctx.fireChannelReadComplete();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
        }
    }
}

