/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.BaseTest;
import pt.com.broker.client.nio.mocks.ServerFactory;
import pt.com.broker.client.nio.mocks.SocketServer;
import pt.com.broker.client.nio.tests.iptables.IpTables;

public abstract class ServerBaseTest
extends BaseTest {
    private static final Logger log = LoggerFactory.getLogger(ServerBaseTest.class);
    int totalServers = 20;
    static IpTables ipTables = new IpTables();
    static String chainName = "java-nio-tests";

    protected List<SocketServer> getServers() {
        int count = (int)(1.0 + Math.random() * (double)this.totalServers);
        return this.getServers(count);
    }

    protected List<SocketServer> getServers(int count) {
        ArrayList<SocketServer> servers = new ArrayList<SocketServer>();
        while (count-- > 0) {
            SocketServer server = ServerFactory.getInstance(0);
            servers.add(server);
        }
        return servers;
    }

    protected List<SocketServer> getRandomServers(Collection<SocketServer> servers) {
        ArrayList<SocketServer> _servers = new ArrayList<SocketServer>(servers);
        Collections.shuffle(_servers);
        return _servers.subList(0, (int)(Math.random() * (double)_servers.size()));
    }

    public boolean userHasPermissions() {
        IpTables ipTables = new IpTables();
        return ipTables.hasPermission();
    }

    protected void ShutDownServers(Collection<SocketServer> servers) {
        for (SocketServer s : servers) {
            Future f = s.shutdown();
            try {
                f.get(20000L, TimeUnit.MILLISECONDS);
                System.out.println("Shutdown Server: " + s);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        if (ipTables.hasPermission()) {
            if (!ipTables.addChain(ServerBaseTest.currentChainName())) {
                System.out.println("Error adding chain:" + ServerBaseTest.currentChainName());
            } else {
                ipTables.addChaintoChain("OUTPUT", ServerBaseTest.currentChainName());
            }
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (ipTables.hasPermission()) {
            ipTables.removeChainfromChain("OUTPUT", ServerBaseTest.currentChainName());
            ipTables.deleteChain(ServerBaseTest.currentChainName());
        }
    }

    public static String currentChainName() {
        String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        return chainName + "-" + pid;
    }
}

