/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import pt.com.broker.client.nio.BaseTest;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.server.strategies.RoundRobinStrategy;

public class TestSelectServerStrategy
extends BaseTest {
    @Test
    public void RoundRobinLoop() {
        ArrayList<HostInfo> list = new ArrayList<HostInfo>();
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        RoundRobinStrategy strategy = new RoundRobinStrategy(list);
        for (HostInfo host : list) {
            Assert.assertSame((Object)host, (Object)strategy.next());
        }
        for (HostInfo host : list) {
            Assert.assertSame((Object)host, (Object)strategy.next());
        }
    }

    @Test
    public void testRoundRobinLoopWithRemove() {
        ArrayList<HostInfo> list = new ArrayList<HostInfo>();
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        RoundRobinStrategy strategy = new RoundRobinStrategy(list);
        for (HostInfo host : list) {
            Assert.assertSame((Object)host, (Object)strategy.next());
        }
        while (list.size() > 0) {
            HostInfo host = strategy.next();
            HostInfo removed = (HostInfo)list.remove(list.size() - 1);
            Assert.assertNotNull((Object)host);
        }
    }

    @Test
    public void testRoundRobinLoopWithRemoveAndAdd() {
        HostInfo host;
        ArrayList<HostInfo> list = new ArrayList<HostInfo>();
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        RoundRobinStrategy strategy = new RoundRobinStrategy(list);
        for (HostInfo host2 : list) {
            Assert.assertSame((Object)host2, (Object)strategy.next());
        }
        while (list.size() > 0) {
            host = strategy.next();
            list.remove(0);
            Assert.assertNotNull((Object)host);
        }
        host = strategy.next();
        Assert.assertNull((Object)host);
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        list.add(new HostInfo("127.0.0.1", 1234));
        for (HostInfo host2 : list) {
            Assert.assertSame((Object)host2, (Object)strategy.next());
        }
    }
}

