/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.tests.iptables;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpTables {
    private static final Logger log = LoggerFactory.getLogger(IpTables.class);
    Runtime rt;
    String iptablesPath = "/sbin/iptables";
    Pattern find_chains_pattern = Pattern.compile("Chain ([\\w-]+) .*");

    public IpTables() {
        this.rt = Runtime.getRuntime();
    }

    public boolean hasPermission() {
        try {
            return this.exec("-L").waitFor() != 3;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean flushChain(String name) throws IOException, InterruptedException {
        String[] params = new String[]{"-F", name};
        return this.exec(params).waitFor() == 0;
    }

    public boolean deleteChain(String name) throws IOException, InterruptedException {
        String[] params = new String[]{"-X", name};
        return this.flushChain(name) && this.exec(params).waitFor() == 0;
    }

    public boolean addChain(String name) throws IOException, InterruptedException {
        String[] params = new String[]{"-N", name};
        return this.exec(params).waitFor() == 0;
    }

    public boolean chainExists(String name) throws IOException, InterruptedException {
        String[] params = new String[]{"-L", name};
        return this.exec(params).waitFor() == 0;
    }

    public boolean removeChainfromChain(String parent, String child) throws IOException, InterruptedException {
        String[] params = new String[]{"-D", parent, "-j", child};
        return this.exec(params).waitFor() == 0;
    }

    public boolean addChaintoChain(String parent, String child) throws IOException, InterruptedException {
        String[] params = new String[]{"-A", parent, "-j", child};
        return this.exec(params).waitFor() == 0;
    }

    public boolean removePortBlock(String chain, int port, TCP_DENY deny) throws IOException, InterruptedException {
        String[] params = new String[]{"-D", chain, "-p", "tcp", "--dport", Integer.toString(port), "-j", deny.name()};
        return this.exec(params).waitFor() == 0;
    }

    public boolean blockPort(String chain, int port, TCP_DENY deny) throws IOException, InterruptedException {
        String[] params = new String[]{"-A", chain, "-p", "tcp", "--dport", Integer.toString(port), "-j", deny.name()};
        return this.exec(params).waitFor() == 0;
    }

    public boolean blockPort(String chain, int port) throws IOException, InterruptedException {
        return this.blockPort(chain, port, TCP_DENY.DROP);
    }

    public boolean removePortBlock(String chain, int port) throws IOException, InterruptedException {
        return this.removePortBlock(chain, port, TCP_DENY.DROP);
    }

    public Collection<String> getChains() throws IOException, InterruptedException {
        String line;
        Process p = this.exec("-L");
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        ArrayList<String> chains = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            Matcher m = this.find_chains_pattern.matcher(line);
            if (!m.find()) continue;
            chains.add(m.group(1));
        }
        return chains;
    }

    protected Process exec(String parameter) throws IOException, InterruptedException {
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add(parameter);
        return this.exec(parameters);
    }

    protected Process exec(String[] _parameters) throws IOException, InterruptedException {
        ArrayList<String> parameters = new ArrayList<String>(_parameters.length);
        for (String param : _parameters) {
            parameters.add(param);
        }
        return this.exec(parameters);
    }

    protected Process exec(Collection<String> parameters) throws IOException, InterruptedException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.iptablesPath);
        command.addAll(parameters);
        ProcessBuilder pb = new ProcessBuilder(command);
        log.debug("Commnad: " + command);
        Process p = pb.start();
        return p;
    }

    public static enum TCP_DENY {
        REJECT,
        DROP;

    }
}

