/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio;

import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.auth.AuthInfo;
import pt.com.broker.auth.CredentialsProvider;
import pt.com.broker.client.nio.AcceptRequest;
import pt.com.broker.client.nio.BrokerClient;
import pt.com.broker.client.nio.bootstrap.ChannelInitializer;
import pt.com.broker.client.nio.events.AcceptResponseListener;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAccepted;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetAuthentication;
import pt.com.broker.types.NetFault;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetProtocolType;

public class SslBrokerClient
extends BrokerClient {
    private static final Logger log = LoggerFactory.getLogger(SslBrokerClient.class);
    protected SSLContext context;
    protected AuthInfo userCredentials;
    private CredentialsProvider credentialsProvider;

    public SslBrokerClient(NetProtocolType ptype) {
        super(ptype);
    }

    public SslBrokerClient(String host, int port) {
        super(host, port);
    }

    public SslBrokerClient(String host, int port, NetProtocolType ptype) {
        super(host, port, ptype);
    }

    public SslBrokerClient(HostInfo host, NetProtocolType ptype) {
        super(host, ptype);
    }

    public SSLContext getContext() {
        return this.context;
    }

    public void setContext(SSLContext context) {
        this.context = context;
        ChannelInitializer channelInitializer = (ChannelInitializer)this.getBootstrap().getChannelInitializer();
        channelInitializer.setContext(context);
    }

    @Override
    public Future<HostInfo> connectAsync() {
        if (this.getContext() == null) {
            this.setContext(this.getDefaultSslContext());
        }
        return super.connectAsync();
    }

    @Override
    public HostInfo connect() {
        if (this.getContext() == null) {
            this.setContext(this.getDefaultSslContext());
        }
        return super.connect();
    }

    private SSLContext getDefaultSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, tmf.getTrustManagers(), new SecureRandom());
            return sc;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public synchronized boolean authenticateClient() throws Throwable {
        if (this.credentialsProvider == null) {
            throw new IllegalStateException("Mandatory Credential Provider missing.");
        }
        this.userCredentials = this.credentialsProvider.getCredentials();
        NetAuthentication clientAuth = new NetAuthentication(this.userCredentials.getToken(), this.userCredentials.getUserAuthenticationType());
        clientAuth.setRoles(this.userCredentials.getRoles());
        if (this.userCredentials.getUserId() != null) {
            clientAuth.setUserId(this.userCredentials.getUserId());
        }
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        AcceptResponseListener acceptedListener = new AcceptResponseListener(){

            @Override
            public void onMessage(NetAccepted message, HostInfo host) {
                queue.add(true);
            }

            @Override
            public void onFault(NetFault fault, HostInfo host) {
                log.error(String.format("Authentication failed: %s", fault.getMessage()));
                queue.add(false);
            }

            @Override
            public void onTimeout(String actionID) {
                log.warn("Authentication failed by timeout.");
                queue.add(false);
            }
        };
        this.sendAuthMessage(clientAuth, acceptedListener, 10000L);
        return (Boolean)queue.take();
    }

    protected Future<HostInfo> sendAuthMessage(NetAuthentication authentication, AcceptResponseListener acceptResponseListener, long timeout) {
        if (acceptResponseListener != null) {
            String actionId = UUID.randomUUID().toString();
            authentication.setActionId(actionId);
            AcceptRequest acceptRequest = new AcceptRequest(actionId, acceptResponseListener, timeout);
            this.addAcceptMessageHandler(acceptRequest);
        }
        NetMessage msg = new NetMessage(new NetAction(authentication));
        return this.sendNetMessage(msg);
    }
}

