/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio;

import java.security.InvalidParameterException;
import java.util.concurrent.Future;
import org.caudexorigo.netty.NettyContext;
import org.caudexorigo.netty.VoidNettyContext;
import pt.com.broker.client.nio.BaseClient;
import pt.com.broker.client.nio.bootstrap.DatagramBootstrap;
import pt.com.broker.client.nio.bootstrap.DatagramChannelInitializer;
import pt.com.broker.client.nio.exceptions.UnavailableAgentException;
import pt.com.broker.client.nio.server.HostContainer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetProtocolType;
import pt.com.broker.types.NetPublish;

public class UdpBrokerClient
extends BaseClient {
    public UdpBrokerClient(NetProtocolType ptype) {
        super(ptype);
        this.connect();
    }

    public UdpBrokerClient(String host, int port) {
        super(host, port);
        this.connect();
    }

    public UdpBrokerClient(String host, int port, NetProtocolType ptype) {
        super(host, port, ptype);
        this.connect();
    }

    public UdpBrokerClient(HostInfo host, NetProtocolType ptype) {
        super(host, ptype);
        this.connect();
    }

    @Override
    public Future<HostInfo> publish(NetPublish message, String destination, NetAction.DestinationType dtype) throws UnavailableAgentException {
        if (message.getActionId() != null) {
            throw new InvalidParameterException("Messages published over UDP are not allowed to carry a message identifier.");
        }
        return super.publish(message, destination, dtype);
    }

    @Override
    protected void init() {
        DatagramChannelInitializer channelInitializer = new DatagramChannelInitializer(this.getSerializer());
        channelInitializer.setOldFraming(this.getProtocolType() == NetProtocolType.SOAP_v0);
        this.setBootstrap(new DatagramBootstrap(channelInitializer, (NettyContext)new VoidNettyContext()));
        this.setHosts(new HostContainer(this.bootstrap));
    }
}

