/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.caudexorigo.netty.NettyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.bootstrap.BaseChannelInitializer;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;

public abstract class BaseBootstrap {
    private static final Logger log = LoggerFactory.getLogger(BaseBootstrap.class);
    private final BaseChannelInitializer channelInitializer;
    private final EventLoopGroup group;
    private final ByteBufAllocator allocator;
    private NettyContext nettyCtx;

    public BaseBootstrap(BaseChannelInitializer channelInitializer, NettyContext nettyCtx) {
        this.channelInitializer = channelInitializer;
        this.nettyCtx = nettyCtx;
        this.allocator = nettyCtx.getAllocator();
        this.group = nettyCtx.getBossEventLoopGroup();
    }

    public ChannelFuture connect(final HostInfo hostInfo) {
        Bootstrap boot = this.getNewInstance(this.allocator);
        boot.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)hostInfo.getConnectTimeout());
        InetSocketAddress socketAddress = new InetSocketAddress(hostInfo.getHostname(), hostInfo.getPort());
        ChannelFuture f = boot.connect((SocketAddress)socketAddress);
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture f) throws Exception {
                if (f.isSuccess()) {
                    ChannelDecorator channel = new ChannelDecorator(f.channel());
                    channel.setHost(hostInfo);
                    hostInfo.setChannel(channel);
                    hostInfo.setStatus(HostInfo.STATUS.OPEN);
                    f.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            hostInfo.setStatus(HostInfo.STATUS.CLOSED);
                            hostInfo.setChannel(null);
                        }
                    });
                } else {
                    hostInfo.setStatus(HostInfo.STATUS.CLOSED);
                }
            }
        });
        return f;
    }

    public BaseChannelInitializer getChannelInitializer() {
        return this.channelInitializer;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public NettyContext getNettyContext() {
        return this.nettyCtx;
    }

    public abstract Bootstrap getNewInstance(ByteBufAllocator var1);

    public Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.group.shutdownGracefully(quietPeriod, timeout, unit);
    }
}

