/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.bootstrap;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.codecs.BrokerMessageDecoder;
import pt.com.broker.client.nio.codecs.BrokerMessageEncoder;
import pt.com.broker.types.BindingSerializer;

public abstract class BaseChannelInitializer
extends ChannelInitializer<Channel> {
    protected static final Logger log = LoggerFactory.getLogger(BaseChannelInitializer.class);
    protected final BindingSerializer serializer;
    private boolean oldFraming = false;

    public BaseChannelInitializer(BindingSerializer serializer) {
        this.serializer = serializer;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.isOldFraming()) {
            pipeline.addLast("broker_message_decoder", (ChannelHandler)new pt.com.broker.client.nio.codecs.oldframing.BrokerMessageDecoder(this.serializer));
            pipeline.addLast("broker_message_encoder", (ChannelHandler)new pt.com.broker.client.nio.codecs.oldframing.BrokerMessageEncoder(this.serializer));
        } else {
            pipeline.addLast("broker_message_decoder", (ChannelHandler)new BrokerMessageDecoder(this.serializer));
            pipeline.addLast("broker_message_encoder", (ChannelHandler)new BrokerMessageEncoder(this.serializer));
        }
        ch.pipeline().addLast("byte_message_encoder", (ChannelHandler)new MessageToByteEncoder<Byte[]>(){

            protected void encode(ChannelHandlerContext ctx, Byte[] msg, ByteBuf out) throws Exception {
                byte[] data = new byte[msg.length];
                int pos = 0;
                for (Byte bye : msg) {
                    data[pos++] = bye;
                }
                out.writeBytes(data);
            }
        });
    }

    protected boolean isOldFraming() {
        return this.oldFraming;
    }

    public void setOldFraming(boolean oldFraming) {
        this.oldFraming = oldFraming;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.debug("********Unexpected exception caught.*********", cause);
    }
}

