/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.bootstrap;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.bootstrap.BaseChannelInitializer;
import pt.com.broker.client.nio.consumer.ConsumerManager;
import pt.com.broker.client.nio.consumer.PendingAcceptRequestsManager;
import pt.com.broker.client.nio.consumer.PongConsumerManager;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.events.connection.ConnectionEventListener;
import pt.com.broker.client.nio.handlers.AcceptMessageHandler;
import pt.com.broker.client.nio.handlers.ConnectionStatusChangeEventHandler;
import pt.com.broker.client.nio.handlers.HeartBeatEventHandler;
import pt.com.broker.client.nio.handlers.PongMessageHandler;
import pt.com.broker.client.nio.handlers.ReceiveFaultHandler;
import pt.com.broker.client.nio.handlers.ReceiveMessageHandler;
import pt.com.broker.types.BindingSerializer;

public class ChannelInitializer
extends BaseChannelInitializer {
    static final Logger log = LoggerFactory.getLogger(ChannelInitializer.class);
    private final PongMessageHandler pongMessageHandler;
    private final ReceiveFaultHandler faultHandler;
    private final AcceptMessageHandler acceptMessageHandler;
    private final ReceiveMessageHandler receiveMessageHandler;
    protected ConsumerManager consumerManager;
    protected PongConsumerManager pongConsumerManager;
    protected PendingAcceptRequestsManager acceptRequestsManager;
    protected SSLContext context;
    private List<ConnectionEventListener> connectionEventListeners;

    public ChannelInitializer(BindingSerializer serializer, ConsumerManager consumerManager, PongConsumerManager pongConsumerManager, List<ConnectionEventListener> connectionEventListeners) {
        super(serializer);
        this.setConsumerManager(consumerManager);
        this.setPongConsumerManager(pongConsumerManager);
        this.connectionEventListeners = connectionEventListeners;
        this.pongMessageHandler = new PongMessageHandler(this.getPongConsumerManager());
        this.faultHandler = new ReceiveFaultHandler(this.getConsumerManager());
        this.acceptMessageHandler = new AcceptMessageHandler(null);
        this.receiveMessageHandler = new ReceiveMessageHandler(this.getConsumerManager());
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        super.initChannel(ch);
        log.debug("**************** Initializing channel! **********************");
        ChannelPipeline pipeline = ch.pipeline();
        SSLContext sslContext = this.getContext();
        if (sslContext != null) {
            SSLEngine engine = sslContext.createSSLEngine();
            engine.setUseClientMode(true);
            pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(engine, false));
        }
        pipeline.addLast("heartbeat_handler", (ChannelHandler)new HeartBeatEventHandler());
        pipeline.addLast("broker_notification_handler", (ChannelHandler)this.receiveMessageHandler);
        pipeline.addLast("broker_pong_handler", (ChannelHandler)this.pongMessageHandler);
        pipeline.addLast("broker_fault_handler", (ChannelHandler)this.faultHandler);
        pipeline.addLast("broker_accept_handler", (ChannelHandler)this.acceptMessageHandler);
        pipeline.addLast("reconnect_handler", (ChannelHandler)new ConnectionStatusChangeEventHandler(this.connectionEventListeners));
        pipeline.addLast("exception_catcher", (ChannelHandler)new ChannelHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                if (!(cause instanceof IOException)) {
                    log.error("*************Unexpected exception caught*********************", cause);
                }
            }
        });
    }

    public ConsumerManager getConsumerManager() {
        return this.consumerManager;
    }

    public void setConsumerManager(ConsumerManager consumerManager) {
        this.consumerManager = consumerManager;
    }

    public PongConsumerManager getPongConsumerManager() {
        return this.pongConsumerManager;
    }

    public void setPongConsumerManager(PongConsumerManager pongConsumerManager) {
        this.pongConsumerManager = pongConsumerManager;
        if (this.pongMessageHandler != null) {
            this.pongMessageHandler.setManager(pongConsumerManager);
        }
    }

    public PendingAcceptRequestsManager getAcceptRequestsManager() {
        return this.acceptRequestsManager;
    }

    public void setAcceptRequestsManager(PendingAcceptRequestsManager acceptRequestsManager) {
        this.acceptRequestsManager = acceptRequestsManager;
        this.acceptMessageHandler.setManager(acceptRequestsManager);
    }

    public SSLContext getContext() {
        return this.context;
    }

    public void setContext(SSLContext context) {
        this.context = context;
    }

    public void setFaultHandler(BrokerListener adapter) {
        this.faultHandler.setFaultListenerAdapter(adapter);
    }
}

