/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.codecs;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.types.BindingSerializer;
import pt.com.broker.types.NetMessage;

public class BrokerMessageDecoder
extends ByteToMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(BrokerMessageDecoder.class);
    private State state = State.Header;
    private Integer bodyLen;
    private final BindingSerializer serializer;

    public BrokerMessageDecoder(BindingSerializer serializer) {
        this.serializer = serializer;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch (this.state) {
            case Header: {
                if (in.readableBytes() < 8) {
                    return;
                }
                this.decodeHeader(in);
                this.state = State.Body;
                break;
            }
            case Body: {
                if (in.readableBytes() < this.bodyLen) {
                    return;
                }
                NetMessage msg = this.decodeBody(in);
                out.add(msg);
                this.state = State.Header;
            }
        }
    }

    protected void decodeHeader(ByteBuf in) {
        in.readShort();
        in.readShort();
        this.bodyLen = in.readInt();
    }

    protected NetMessage decodeBody(ByteBuf in) {
        byte[] body = new byte[this.bodyLen.intValue()];
        in.readBytes(body);
        return this.serializer.unmarshal(body);
    }

    private static enum State {
        Header,
        Body;

    }
}

