/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.consumer;

import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;

public class BrokerAsyncConsumer {
    private final NetAction.DestinationType destinationType;
    private final String destinationName;
    private final BrokerListener listener;
    private String actionId;
    private HostInfo host;

    public BrokerAsyncConsumer(String destinationName, NetAction.DestinationType destinationType, BrokerListener listener) {
        this.destinationType = destinationType;
        this.listener = listener;
        this.destinationName = destinationName;
    }

    public boolean deliver(NetMessage msg, HostInfo host) throws Throwable {
        this.listener.deliverMessage(msg, host);
        return true;
    }

    public NetAction.DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public HostInfo getHost() {
        return this.host;
    }

    public void setHost(HostInfo host) {
        this.host = host;
    }

    public BrokerListener getListener() {
        return this.listener;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }
}

