/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.consumer;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import pt.com.broker.client.nio.events.AcceptResponseListener;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.ActionIdDecorator;
import pt.com.broker.types.NetMessage;

public class PendingAcceptRequestsManager {
    private final Map<String, BrokerListener> requests = new HashMap<String, BrokerListener>();
    private final ScheduledExecutorService schedule = Executors.newScheduledThreadPool(2);
    private final Map<String, ScheduledFuture> schedules = new HashMap<String, ScheduledFuture>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptRequest(final String actionID, long timeout, BrokerListener listener) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)actionID), (Object)"Invalid actionID");
        Map<String, BrokerListener> map = this.requests;
        synchronized (map) {
            if (this.requests.containsKey(actionID)) {
                throw new Exception("ActionID already registered");
            }
            this.requests.put(actionID, listener);
            Runnable command = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = PendingAcceptRequestsManager.this.requests;
                    synchronized (map) {
                        AcceptResponseListener _listener = (AcceptResponseListener)PendingAcceptRequestsManager.this.getListener(actionID);
                        if (_listener != null) {
                            PendingAcceptRequestsManager.this.removeAcceptRequest(actionID);
                            _listener.onTimeout(actionID);
                        }
                    }
                }
            };
            ScheduledFuture<?> f = this.schedule.schedule(command, timeout, TimeUnit.MILLISECONDS);
            this.schedules.put(actionID, f);
        }
    }

    public AcceptResponseListener removeAcceptRequest(String actionID) {
        AcceptResponseListener b = (AcceptResponseListener)this.requests.remove(actionID);
        if (b != null) {
            this.cancelTimeout(actionID);
        }
        return b;
    }

    public BrokerListener getListener(String actionID) {
        return this.requests.get(actionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cancelTimeout(String actionID) {
        boolean cancel_return = false;
        Map<String, ScheduledFuture> map = this.schedules;
        synchronized (map) {
            Future f = this.schedules.get(actionID);
            if (f != null) {
                cancel_return = f.cancel(false);
            }
            this.schedules.remove(actionID);
        }
        return cancel_return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverMessage(NetMessage netMessage, HostInfo host) throws Exception {
        ActionIdDecorator decorator = new ActionIdDecorator(netMessage);
        String actionID = decorator.getActionId();
        if (StringUtils.isEmpty((CharSequence)actionID)) {
            throw new Exception("Invalid actionID");
        }
        Map<String, BrokerListener> map = this.requests;
        synchronized (map) {
            BrokerListener listener = this.getListener(actionID);
            if (listener != null) {
                try {
                    listener.deliverMessage(netMessage, host);
                    this.removeAcceptRequest(actionID);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }
}

