/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.consumer;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.events.BrokerListener;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.types.ActionIdDecorator;
import pt.com.broker.types.NetMessage;

public class PongConsumerManager {
    private static final Logger log = LoggerFactory.getLogger(PongConsumerManager.class);
    volatile ConcurrentHashMap<String, BrokerListener> pongMessages = new ConcurrentHashMap();

    public BrokerListener removeSubscription(String actionId) {
        if (actionId == null) {
            throw new RuntimeException("Invalid actionID null");
        }
        return this.pongMessages.remove(actionId);
    }

    public void addSubscription(String actionId, BrokerListener listener) {
        if (actionId == null) {
            throw new RuntimeException("Invalid actionID null");
        }
        this.pongMessages.put(actionId, listener);
    }

    public void deliverMessage(NetMessage netMessage, HostInfo host) throws Throwable {
        String actionid = this.getActionId(netMessage);
        BrokerListener listener = this.pongMessages.get(actionid);
        if (listener == null) {
            throw new IllegalArgumentException("No listener found for the actionId: " + actionid);
        }
        log.debug("Delivering pong message:  " + actionid);
        listener.deliverMessage(netMessage, host);
    }

    private String getActionId(NetMessage msg) {
        ActionIdDecorator decorator = new ActionIdDecorator(msg);
        return decorator.getActionId();
    }
}

