/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.consumer.PendingAcceptRequestsManager;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;

@ChannelHandler.Sharable
public class AcceptMessageHandler
extends SimpleChannelInboundHandler<NetMessage> {
    private static final Logger log = LoggerFactory.getLogger(AcceptMessageHandler.class);
    PendingAcceptRequestsManager manager;

    public AcceptMessageHandler(PendingAcceptRequestsManager manager) {
        this.manager = manager;
    }

    protected void channelRead0(ChannelHandlerContext ctx, NetMessage msg) throws Exception {
        NetAction action = msg.getAction();
        if (action.getActionType() != NetAction.ActionType.ACCEPTED && action.getActionType() != NetAction.ActionType.FAULT) {
            ctx.fireChannelRead((Object)msg);
            return;
        }
        if (action.getActionType() == NetAction.ActionType.FAULT) {
            String actionId = action.getFaultMessage().getActionId();
            log.debug("Got Fault Message.  ActionId: {}", (Object)actionId);
            if (this.manager.getListener(actionId) == null) {
                ctx.fireChannelRead((Object)msg);
                return;
            }
        }
        ChannelDecorator decorator = new ChannelDecorator(ctx.channel());
        this.manager.deliverMessage(msg, decorator.getHost());
    }

    public PendingAcceptRequestsManager getManager() {
        return this.manager;
    }

    public void setManager(PendingAcceptRequestsManager manager) {
        this.manager = manager;
    }
}

