/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.handlers;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.events.connection.ConnectionEventListener;
import pt.com.broker.client.nio.events.connection.ConnectionStatusChangeEvent;

public class ConnectionStatusChangeEventHandler
extends ChannelDuplexHandler {
    private static final Logger log = LoggerFactory.getLogger(ConnectionStatusChangeEventHandler.class);
    private List<ConnectionEventListener> connectionEventListeners;

    public ConnectionStatusChangeEventHandler(List<ConnectionEventListener> connectionEventListeners) {
        Preconditions.checkNotNull(connectionEventListeners, (Object)"The event listeners cannot be null.");
        this.connectionEventListeners = connectionEventListeners;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectionStatusChangeEvent) {
            this.notifyListeners((ConnectionStatusChangeEvent)evt);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    private void notifyListeners(ConnectionStatusChangeEvent event) {
        log.debug("Status {} to host {}", (Object)event.getConnectionStatus(), (Object)event.getHostInfo().toString());
        for (ConnectionEventListener listener : this.connectionEventListeners) {
            switch (event.getConnectionStatus()) {
                case CLOSED: {
                    log.debug("Notifying listener for disconnected agent.");
                    listener.disconnected(event.getHostInfo());
                    break;
                }
                case CONNECTING: {
                    break;
                }
                case DISABLE: {
                    log.debug("Notifying listener for disconnected agent.");
                    listener.disconnected(event.getHostInfo());
                    break;
                }
                case OPEN: {
                    log.debug("Notifying listener for connected agent.");
                    listener.connected(event.getHostInfo());
                    break;
                }
            }
        }
    }
}

