/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.com.broker.client.nio.consumer.ConsumerManager;
import pt.com.broker.client.nio.server.HostInfo;
import pt.com.broker.client.nio.utils.ChannelDecorator;
import pt.com.broker.client.nio.utils.NetNotificationDecorator;
import pt.com.broker.types.NetAction;
import pt.com.broker.types.NetMessage;
import pt.com.broker.types.NetNotification;

@ChannelHandler.Sharable
public class ReceiveMessageHandler
extends SimpleChannelInboundHandler<NetMessage> {
    private static final Logger log = LoggerFactory.getLogger(ReceiveMessageHandler.class);
    ConsumerManager manager;

    public ReceiveMessageHandler(ConsumerManager manager) {
        this.manager = manager;
    }

    protected void channelRead0(ChannelHandlerContext ctx, NetMessage msg) {
        if (ctx == null) {
            return;
        }
        try {
            NetAction action = msg.getAction();
            switch (action.getActionType()) {
                case NOTIFICATION: {
                    NetNotificationDecorator decorator = new NetNotificationDecorator(msg.getAction().getNotificationMessage(), this.getHost(ctx.channel()));
                    msg.getAction().setNotificationMessage((NetNotification)decorator);
                    this.deliverNotification(ctx, msg);
                    ctx.fireChannelReadComplete();
                    break;
                }
                default: {
                    ctx.fireChannelRead((Object)msg);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public ConsumerManager getManager() {
        return this.manager;
    }

    private void deliverNotification(ChannelHandlerContext ctx, NetMessage msg) throws Throwable {
        this.manager.deliverMessage(msg, this.getHost(ctx.channel()));
    }

    private HostInfo getHost(Channel channel) {
        ChannelDecorator decorator = new ChannelDecorator(channel);
        return decorator.getHost();
    }
}

