/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.client.nio.server;

import io.netty.channel.Channel;

public final class HostInfo {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    public static final int DEFAULT_RECONNECT_LIMIT = 10;
    private String hostname;
    private int port;
    private int connectTimeout;
    private int reconnectLimit = 10;
    private Channel channel;
    private STATUS status = STATUS.CLOSED;
    private long readerIdleTime = 40000L;
    private long writerIdleTime = 20000L;

    public HostInfo(String hostname, int port) {
        this(hostname, port, 15000);
    }

    public HostInfo(String hostname, int port, int connectTimeout) {
        this.hostname = hostname;
        this.port = port;
        this.connectTimeout = connectTimeout;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public synchronized int getConnectTimeout() {
        return this.connectTimeout;
    }

    public synchronized void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        HostInfo other = (HostInfo)obj;
        if (!this.hostname.equals(other.hostname)) {
            return false;
        }
        return this.port == other.port;
    }

    public String toString() {
        return String.format("HostInfo [hostname=%s, port=%s]", this.hostname, this.port);
    }

    public boolean isActive() {
        return this.getChannel() != null && this.getChannel().isActive() && this.getChannel().isOpen() && this.getChannel().isWritable();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public synchronized int getReconnectLimit() {
        return this.reconnectLimit;
    }

    public synchronized void setReconnectLimit(int reconnectLimit) {
        this.reconnectLimit = reconnectLimit;
    }

    protected synchronized void resetReconnectLimit() {
        this.setReconnectLimit(10);
    }

    protected synchronized void reconnectAttempt() {
        if (this.reconnectLimit-- <= 0) {
            // empty if block
        }
    }

    public synchronized STATUS getStatus() {
        return this.status;
    }

    public synchronized void setStatus(STATUS status) {
        this.status = status;
    }

    public long getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public synchronized void setReaderIdleTime(long readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public long getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public synchronized void setWriterIdleTime(long writerIdleTime) {
        this.writerIdleTime = writerIdleTime;
    }

    public static enum STATUS {
        OPEN,
        CONNECTING,
        CLOSED,
        DISABLE;

    }
}

