/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.auth.saposts;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pt.com.broker.auth.AuthInfo;
import pt.com.broker.auth.AuthInfoValidator;
import pt.com.broker.auth.AuthValidationResult;
import pt.com.broker.auth.ProviderInfo;
import pt.com.broker.auth.saposts.SapoSTSCodeErrors;
import pt.com.broker.auth.saposts.SapoSTSNamespaceContext;
import pt.com.broker.auth.saposts.SapoSTSParameterProvider;
import pt.com.broker.auth.saposts.SapoSTSService;

public class SapoSTSAuthInfoValidator
implements AuthInfoValidator {
    private static final SapoSTSAuthValidationResult internalError = new SapoSTSAuthValidationResult("Internal error");

    public AuthValidationResult validate(AuthInfo clientAuthInfo) throws Exception {
        URL url = new URL(this.getConnectionUrl(clientAuthInfo, SapoSTSService.getAgentAuthenticationInfo()));
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return internalError;
        }
        HttpURLConnection httpUrlconn = (HttpURLConnection)connection;
        int respCode = httpUrlconn.getResponseCode();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
        InputStream inputStream = null;
        if (respCode == 200) {
            connection.getContent();
            inputStream = httpUrlconn.getInputStream();
        } else if (respCode == 500) {
            inputStream = httpUrlconn.getErrorStream();
        } else {
            return internalError;
        }
        Document doc = documentBuilder.parse(inputStream);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)SapoSTSNamespaceContext.getInstance());
        SapoSTSAuthValidationResult avr = null;
        if (respCode == 200) {
            NodeList roleNodes = (NodeList)xpath.evaluate("/GetRolesResponse/GetRolesResult/ESBRoles/ESBRole", doc, XPathConstants.NODESET);
            List<String> roles = null;
            roles = roleNodes.getLength() != 0 ? this.extractRoles(roleNodes) : new ArrayList<String>(1);
            System.out.println("ROLES: " + Arrays.toString(roles.toArray()));
            avr = new SapoSTSAuthValidationResult(roles);
        } else {
            Element codeElem = (Element)((NodeList)xpath.evaluate("/fault/detail/exceptionInfo/code", doc, XPathConstants.NODESET)).item(0);
            avr = new SapoSTSAuthValidationResult(SapoSTSCodeErrors.getErrorDescription(codeElem.getTextContent()));
        }
        return avr;
    }

    private List<String> extractRoles(NodeList roleNodes) {
        ArrayList<String> roles = new ArrayList<String>(roleNodes.getLength());
        for (int i = 0; i != roleNodes.getLength(); ++i) {
            Node item = roleNodes.item(i);
            if (!(item instanceof Element)) continue;
            Element elem = (Element)item;
            roles.add(elem.getTextContent());
        }
        return roles;
    }

    private String getConnectionUrl(AuthInfo clientAuthInfo, AuthInfo agentAuthInfo) {
        String sapoSTSUrl = "https://services.bk.sapo.pt/STS/";
        SapoSTSParameterProvider.Parameters parameters = SapoSTSParameterProvider.getSTSParameters();
        if (parameters != null && parameters.getLocation() != null) {
            sapoSTSUrl = parameters.getLocation();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sapoSTSUrl);
        sb.append("GetRoles?");
        sb.append("ESBToken=");
        sb.append(new String(agentAuthInfo.getToken(), Charset.forName("UTF-8")));
        sb.append("&UserToken=");
        sb.append(new String(clientAuthInfo.getToken(), Charset.forName("UTF-8")));
        return sb.toString();
    }

    public boolean init(ProviderInfo info) {
        return SapoSTSService.start((ProviderInfo)info);
    }

    public static class SapoSTSAuthValidationResult
    implements AuthValidationResult {
        private boolean valid;
        private String reasonForFailure;
        private List<String> roles;

        public SapoSTSAuthValidationResult(List<String> roles) {
            this.valid = true;
            this.roles = roles;
        }

        public SapoSTSAuthValidationResult(String reasonForFailure) {
            this.valid = false;
            this.reasonForFailure = reasonForFailure;
        }

        public boolean areCredentialsValid() {
            return this.valid;
        }

        public String getReasonForFailure() {
            return this.reasonForFailure;
        }

        public List<String> getRoles() {
            return this.roles;
        }
    }
}

