/*
 * Decompiled with CFR 0.152.
 */
package pt.com.broker.auth.saposts;

import java.net.URL;
import java.nio.charset.Charset;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang3.StringUtils;
import pt.com.broker.auth.AuthInfo;
import pt.com.broker.auth.CredentialsProvider;
import pt.com.broker.auth.ProviderInfo;
import pt.com.broker.auth.saposts.SAPOStsToken;
import pt.sapo.services.definitions.STS;
import pt.sapo.services.definitions.STSSoapSecure;

public class SapoSTSProvider
implements CredentialsProvider {
    public static final String DEFAULT_BASE_URL = "https://services.bk.sapo.pt/STS/";
    private final String providerName = "SapoSTS";
    private final String username;
    private final String password;
    private final String stsLocation;
    private final SAPOStsToken stsToken;

    public SapoSTSProvider(String username, String password) {
        this(username, password, DEFAULT_BASE_URL);
    }

    public SapoSTSProvider(String username, String password, String stsLocation) {
        if (StringUtils.isBlank((CharSequence)stsLocation)) {
            throw new IllegalArgumentException("STS Location URL must not be blank");
        }
        this.username = username;
        this.password = password;
        this.stsLocation = stsLocation;
        this.stsToken = new SAPOStsToken(this.getClient(stsLocation));
    }

    public AuthInfo getCredentials() throws Exception {
        String strToken = this.stsToken.getToken(this.username, this.password);
        byte[] token = strToken.getBytes(Charset.forName("UTF-8"));
        AuthInfo aui = new AuthInfo(this.username, null, token, "SapoSTS");
        return aui;
    }

    public boolean init(ProviderInfo info) {
        return true;
    }

    public String getAuthenticationType() {
        return "SapoSTS";
    }

    public String toString() {
        return "SapoSTSProvider [providerName=SapoSTS, stsLocation=" + this.stsLocation + "]";
    }

    protected STSSoapSecure getClient(String base_url) {
        URL url = null;
        try {
            url = STSSoapSecure.class.getClassLoader().getResource("STS.wsdl");
            STS sts = new STS(url);
            STSSoapSecure secure = sts.getSTSSoapSecure();
            BindingProvider bp = (BindingProvider)secure;
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", base_url);
            return secure;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

