/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.api.CanaisAPI;
import pt.sapo.hpviagens.api.MainMenuApiList;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = -3173774769371117459L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private static NewsDb instance = new NewsDb();
    private MainMenuApiList menus;
    private CanaisAPI canais;
    private Map<String, CanaisAPI> itemBySlug;
    private Map<String, CanaisAPI> itemByUrl;
    private Date lastModified = new Date();

    private NewsDb() {
        File adbFile = new File("./news.db");
        if (adbFile.exists()) {
            try (FileInputStream fis = new FileInputStream(adbFile);
                 ObjectInputStream in = new ObjectInputStream(fis);){
                NewsDb ard = (NewsDb)in.readObject();
                this.init(ard.doGetMenus(), ard.doGetAllItemBySlug(), ard.doGetAllItemByUrl());
            }
            catch (Throwable t) {
                Shutdown.now((Throwable)t);
            }
        } else {
            this.init(new MainMenuApiList(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>());
        }
    }

    private static synchronized void dump(NewsDb adb) {
        File outFile = new File("./news.db.tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            File dstFile = new File("./news.db");
            Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void build(MainMenuApiList _menus, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl) {
        log.info("build(CanaisApiList menus)");
        NewsDb adb = new NewsDb(_menus, _lstPagesBySlug, _lstPagesByUrl);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        log.info("build(InputStream input)");
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adb = (NewsDb)in.readObject();
            NewsDb.dump(adb);
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public NewsDb(MainMenuApiList _menus, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl) {
        this.init(_menus, _lstPagesBySlug, _lstPagesByUrl);
    }

    private void init(MainMenuApiList _menus, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl) {
        this.itemBySlug = new HashMap<String, CanaisAPI>();
        this.itemByUrl = new HashMap<String, CanaisAPI>();
        this.menus = _menus;
        this.fillLookupTables(_lstPagesBySlug, _lstPagesByUrl);
        this.lastModified = new Date();
    }

    private void fillLookupTables(Map<String, CanaisAPI> _lstPagesBySlug, Map<String, CanaisAPI> _lstPagesByUrl) {
        this.itemBySlug = _lstPagesBySlug;
        this.itemByUrl = _lstPagesByUrl;
    }

    public static final MainMenuApiList getMenus() {
        return instance.doGetMenus();
    }

    private MainMenuApiList doGetMenus() {
        return this.menus;
    }

    public static final CanaisAPI getCanais() {
        return instance.doGetCanais();
    }

    private CanaisAPI doGetCanais() {
        return this.canais;
    }

    public static final CanaisAPI getItemByUrl(String url) {
        return instance.doGetItemByUrl(url);
    }

    public static final CanaisAPI getItemBySlug(String slug) {
        return instance.doGetItemBySlug(slug);
    }

    private Map<String, CanaisAPI> doGetAllItemBySlug() {
        return this.itemByUrl;
    }

    private Map<String, CanaisAPI> doGetAllItemByUrl() {
        return this.itemByUrl;
    }

    private CanaisAPI doGetItemBySlug(String slug) {
        return this.itemBySlug.get(slug);
    }

    private CanaisAPI doGetItemByUrl(String url) {
        return this.itemByUrl.get(url);
    }

    public static final Date getLastModified() {
        return instance.doGetLastModified();
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static Object getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }

    public static Object getArticleByUrl(String url) {
        return NewsDb.instance.itemByUrl.get(url);
    }

    private void fillLookupTables(List<CanaisAPI> lst) {
        if (lst != null) {
            for (CanaisAPI ci : lst) {
                this.itemBySlug.put(ci.getSlug(), ci);
                this.itemByUrl.put(ci.getUrl(), ci);
            }
        }
    }
}

