/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.tools;

import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.hpviagens.api.CanaisAPI;
import pt.sapo.hpviagens.api.CanaisListAPI;
import pt.sapo.hpviagens.api.MainMenuApiList;
import pt.sapo.hpviagens.tools.JsonCanaisApiResponseHandler;
import pt.sapo.hpviagens.tools.JsonCanaisListApiResponseHandler;
import pt.sapo.hpviagens.tools.JsonMainMenuApiResponseHandler;

public class HttpClient {
    private static Logger log = LoggerFactory.getLogger(HttpClient.class);
    private CloseableHttpClient httpclient;
    private final JsonMainMenuApiResponseHandler rsp_main_menu_handler = new JsonMainMenuApiResponseHandler();
    private final JsonCanaisApiResponseHandler rsp_canais_handler = new JsonCanaisApiResponseHandler();
    private final JsonCanaisListApiResponseHandler rsp_canais_list_handler = new JsonCanaisListApiResponseHandler();

    public HttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(10);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).build();
        this.httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    private CanaisAPI doHttpRequestCanaisAPI(HttpRequestBase httpget, JsonCanaisApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (CanaisAPI)this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s%n", r.getMessage()));
            return null;
        }
    }

    public CanaisAPI doHttpGetCanaisAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisAPI((HttpRequestBase)httpget, this.rsp_canais_handler);
    }

    private CanaisListAPI doHttpRequestCanaisListAPI(HttpRequestBase httpget, JsonCanaisListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (CanaisListAPI)this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_list_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s%n", r.getMessage()));
            return null;
        }
    }

    public CanaisListAPI doHttpGetCanaisListAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisListAPI((HttpRequestBase)httpget, this.rsp_canais_list_handler);
    }

    private MainMenuApiList doHttpRequestMainMenuAPI(HttpRequestBase httpget, JsonMainMenuApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (MainMenuApiList)this.httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_main_menu_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s%n", r.getMessage()));
            return null;
        }
    }

    public MainMenuApiList doHttpGetMainMenuAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestMainMenuAPI((HttpRequestBase)httpget, this.rsp_main_menu_handler);
    }
}

