/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.hpviagens.tools;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ThumbsEpic {
    private static final byte[] AES_KEY = "88f1bfa0ffa70edd02e656348a19e1ab".getBytes();
    private static final String IV_SUFFIX = "eu vi um sapo";
    private static final ThumbsEpic instance = new ThumbsEpic();
    private final SecretKey aesKey;
    private final Base64.Encoder b64_encoder;
    static final int MAX_THUMB_SIZE = 1280;

    private ThumbsEpic() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            field.set(null, Boolean.FALSE);
            this.aesKey = new SecretKeySpec(AES_KEY, "AES");
            this.b64_encoder = Base64.getEncoder();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private String doCreate(String url) {
        if (url != null && url.startsWith("//")) {
            url = String.format("http:%s", url);
        }
        try {
            String ivstart = ThumbsEpic.hash(url).substring(0, 3);
            byte[] iv = (ivstart + IV_SUFFIX).getBytes();
            IvParameterSpec iv_spec = new IvParameterSpec(iv);
            String b64_ivstart = this.b64_encoder.encodeToString(ivstart.getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.aesKey, iv_spec);
            byte[] buf_cipher_text = cipher.doFinal(url.getBytes());
            String b64_cipher_text = this.b64_encoder.encodeToString(buf_cipher_text);
            return b64_ivstart.concat(b64_cipher_text);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String hash(String in) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(in.getBytes());
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static String create(String url) {
        return instance.doCreate(url);
    }

    public static String create(String url, String w, String h) {
        String epic = ThumbsEpic.create(url);
        int _w = Integer.parseInt(w);
        int _h = Integer.parseInt(h);
        _w = Math.min(_w, 1280);
        if ((_h = Math.min(_h, 1280)) > _w) {
            return String.format("http://thumbs.web.sapo.io/?epic=%s&H=%d", epic, _h);
        }
        if (_w >= _h) {
            return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%d", epic, _w);
        }
        return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&H=%s", epic, w, h);
    }

    public static String createMB(String url, String w, String h) {
        String epic = ThumbsEpic.create(url);
        int _w = Integer.parseInt(w);
        int _h = Integer.parseInt(h);
        _w = Math.min(_w, 1280);
        if ((_h = Math.min(_h, 1280)) > _w) {
            return String.format("http://thumbs.web.sapo.io/?epic=%s&H=%d&delay_optim=1", epic, _h);
        }
        if (_w >= _h) {
            return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%d&delay_optim=1", epic, _w);
        }
        return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&H=%s&delay_optim=1", epic, w, h);
    }

    public static String create(String url, String w, String h, String crop) {
        String epic = ThumbsEpic.create(url);
        return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&H=%s&crop=%s", epic, w, h, crop);
    }

    public static String createMB(String url, String w, String h, String crop) {
        String epic = ThumbsEpic.create(url);
        return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&H=%s&crop=%s&delay_optim=1", epic, w, h, crop);
    }

    public static String createMBW(String url, String w) {
        String epic = ThumbsEpic.create(url);
        return String.format("http://thumbs.web.sapo.io/?epic=%s&W=%s&delay_optim=1", epic, w);
    }

    public static String createMBH(String url, String h) {
        String epic = ThumbsEpic.create(url);
        return String.format("http://thumbs.web.sapo.io/?epic=%s&H=%s&delay_optim=1", epic, h);
    }

    public static void main(String[] args) {
        String link = "http://images-cdn.impresa.pt/expresso/2015-07-24-Pedro-Passos-Coelho---Legislativas-1/original/mw-640";
        System.out.printf("Plain url: %s%n", link);
        String enc = ThumbsEpic.create(link);
        System.out.printf("Encripted: %s%n", enc);
        System.out.printf("Thumb url: http://thumbs.web.sapo.io/?epic=%s&H=100%n", enc);
    }
}

