/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.util.Objects;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;

public class BaseJptNodeBuilder {
    private StringBuilder _buffer;

    public BaseJptNodeBuilder(StringBuilder sb) {
        this._buffer = sb;
    }

    public void process(Document doc) {
        int childCount = doc.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.processChild(doc.getChild(i));
        }
    }

    protected void process(Element element) {
        Node child;
        int i;
        boolean hasRealChildren = false;
        int childCount = element.getChildCount();
        for (i = 0; i < childCount; ++i) {
            Text t;
            child = element.getChild(i);
            if (child instanceof Text && (t = (Text)child).getValue().length() == 0) continue;
            hasRealChildren = true;
            break;
        }
        if (hasRealChildren) {
            this.processStartTag(element);
            for (i = 0; i < childCount; ++i) {
                child = element.getChild(i);
                this.processChild(child);
            }
            this.processEndTag(element);
        } else {
            this.processEmptyElementTag(element);
        }
    }

    protected void processEndTag(Element element) {
        this._buffer.append("</");
        this._buffer.append(element.getQualifiedName());
        this._buffer.append('>');
    }

    protected void processStartTag(Element element) {
        this.processTagBeginning(element);
        this._buffer.append('>');
    }

    protected void processEmptyElementTag(Element element) {
        this.processTagBeginning(element);
        this._buffer.append("/>");
    }

    private void processTagBeginning(Element element) {
        this._buffer.append('<');
        this._buffer.append(element.getQualifiedName());
        this.processAttributes(element);
        this.processNamespaceDeclarations(element);
    }

    protected void processAttributes(Element element) {
        int attributeCount = element.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = element.getAttribute(i);
            this._buffer.append(' ');
            this.process(attribute);
        }
    }

    protected void processNamespaceDeclarations(Element element) {
        for (int i = 0; i < element.getNamespaceDeclarationCount(); ++i) {
            Element parentElement;
            ParentNode parentNode;
            String additionalPrefix = element.getNamespacePrefix(i);
            String uri = element.getNamespaceURI(additionalPrefix);
            if (this.isJptNs(uri) || ((parentNode = element.getParent()) != null && parentNode instanceof Element ? uri.equals((parentElement = (Element)parentNode).getNamespaceURI(additionalPrefix)) : uri.length() == 0)) continue;
            this._buffer.append(" xmlns");
            if (additionalPrefix.length() > 0) {
                this._buffer.append(':');
                this._buffer.append(additionalPrefix);
            }
            this._buffer.append("=\"");
            this._buffer.append(uri);
            this._buffer.append('\"');
        }
    }

    private boolean isJptNs(String uri) {
        return uri.equals("http://xml.zope.org/namespaces/tal") || uri.equals("http://xml.zope.org/namespaces/metal") || uri.equals("http://xml.zope.org/namespaces/metal/append-to-slot");
    }

    protected static <T> T coalesce(T ... values) {
        for (T v : values) {
            if (!Objects.nonNull(v)) continue;
            return v;
        }
        return null;
    }

    protected void process(Attribute attribute) {
        this._buffer.append(attribute.getQualifiedName());
        this._buffer.append("=\"");
        this._buffer.append(attribute.getValue());
        this._buffer.append('\"');
    }

    protected void process(Comment comment) {
        this._buffer.append("<!--");
        this._buffer.append(comment.getValue());
        this._buffer.append("-->");
    }

    protected void process(Text text) {
        String value = text.getValue();
        this._buffer.append(value);
    }

    protected void process(DocType doctype) {
        this._buffer.append("<!DOCTYPE ");
        this._buffer.append(doctype.getRootElementName());
        if (doctype.getPublicID() != null) {
            this._buffer.append(" PUBLIC \"" + doctype.getPublicID() + "\" \"" + doctype.getSystemID() + "\"");
        } else if (doctype.getSystemID() != null) {
            this._buffer.append(" SYSTEM \"" + doctype.getSystemID() + "\"");
        }
        this._buffer.append(">\n");
    }

    private void process(ProcessingInstruction pi) {
    }

    protected void processChild(Node node) {
        if (node instanceof Element) {
            this.process((Element)node);
        } else if (node instanceof Text) {
            this.process((Text)node);
        } else if (node instanceof Comment) {
            this.process((Comment)node);
        } else if (node instanceof ProcessingInstruction) {
            this.process((ProcessingInstruction)node);
        } else if (node instanceof DocType) {
            this.process((DocType)node);
        } else {
            throw new XMLException("Cannot process a " + node.getClass().getName() + " from the processChild() method");
        }
    }

    protected final void processAttributeValue(String value) {
        this._buffer.append(value);
    }

    protected final void processRaw(String text) {
        this._buffer.append(text);
    }

    public StringBuilder getBuffer() {
        return this._buffer;
    }

    public void setBuffer(StringBuilder buf) {
        this._buffer = buf;
    }
}

