/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.jpt.JptNode;
import org.caudexorigo.jpt.JptParentNode;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class JptConditionalNode
extends JptParentNode {
    private Serializable _compiled_exp;
    private boolean _isInSlot;
    private String _bool_exp;

    JptConditionalNode(String jpt_exp, boolean isInSlot) {
        this._isInSlot = isInSlot;
        this._bool_exp = StringUtils.isBlank((CharSequence)jpt_exp) ? "true" : StringUtils.replace((String)jpt_exp, (String)"'", (String)"\"");
    }

    @Override
    boolean isConditionalNode() {
        return true;
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        try {
            boolean condition;
            if (this._compiled_exp == null) {
                ParserContext parser_context = ParserContext.create();
                Set<Map.Entry<String, Object>> ctx_entries = context.entrySet();
                for (Map.Entry<String, Object> entry : ctx_entries) {
                    parser_context.addInput(entry.getKey(), entry.getValue().getClass());
                }
                this._compiled_exp = MVEL.compileExpression((String)this._bool_exp, (ParserContext)parser_context);
            }
            if (condition = ((Boolean)MVEL.executeExpression((Object)this._compiled_exp, context)).booleanValue()) {
                int child_count = this.getChildCount();
                for (int i = 0; i < child_count; ++i) {
                    JptNode jpt_node = this.getChild(i);
                    jpt_node.render(context, out);
                }
            }
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            throw new RuntimeException(String.format("Error processing JptConditionalNode:%nexpression: '%s';%ncontext: %s;%nmessage: '%s'", this._bool_exp, context, r.getMessage()));
        }
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }
}

