/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Document;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.jpt.Dependency;
import org.caudexorigo.jpt.JptDocument;
import org.caudexorigo.jpt.JptException;
import org.caudexorigo.jpt.JptNodeBuilder;
import org.caudexorigo.xom.XomDocumentBuilder;

public class JptInstance {
    private JptDocument _jptDocument;
    private ArrayList<Dependency> _dependecies;

    public JptInstance(URI templateUri) {
        Document doc;
        try {
            doc = XomDocumentBuilder.getDocument(templateUri);
        }
        catch (Throwable t) {
            throw new JptException(t);
        }
        JptNodeBuilder nbuilder = new JptNodeBuilder();
        nbuilder.process(doc, templateUri);
        this._dependecies = nbuilder.getDependecies();
        Dependency d = new Dependency(templateUri);
        this._dependecies.add(d);
        this._jptDocument = nbuilder.getJptDocument();
    }

    public JptInstance(InputStream in_io, String resourcePath) {
        Document doc;
        try {
            doc = XomDocumentBuilder.getDocument(in_io);
        }
        catch (Exception e) {
            throw new JptException(e);
        }
        URI resourceUri = URI.create(resourcePath);
        JptNodeBuilder nbuilder = new JptNodeBuilder();
        nbuilder.process(doc, resourceUri);
        this._jptDocument = nbuilder.getJptDocument();
    }

    public void render(Writer out) throws Throwable {
        String obj_type_name = StringUtils.isBlank((CharSequence)this._jptDocument.getCtxObjectType()) ? "java.lang.Object" : this._jptDocument.getCtxObjectType();
        Object oCtx = Class.forName(obj_type_name).newInstance();
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("$this", oCtx);
        this._jptDocument.render(renderContext, out);
    }

    public void render(Map<String, Object> renderContext, Writer out) throws Throwable {
        this._jptDocument.render(renderContext, out);
    }

    public String getCtxObjectType() {
        return this._jptDocument.getCtxObjectType();
    }

    public ArrayList<Dependency> getDependecies() {
        return this._dependecies;
    }

    public JptDocument getJptDocument() {
        return this._jptDocument;
    }
}

