/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import org.caudexorigo.ds.Cache;
import org.caudexorigo.ds.CacheFiller;
import org.caudexorigo.jpt.Dependency;
import org.caudexorigo.jpt.JptConfiguration;
import org.caudexorigo.jpt.JptInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JptInstanceBuilder {
    private static final Logger log = LoggerFactory.getLogger(JptInstanceBuilder.class);
    private final Cache<URI, JptInstance> template_cache = new Cache();
    private static final JptInstanceBuilder instance = new JptInstanceBuilder();
    private static final CacheFiller<URI, JptInstance> template_cache_listeners_cf = new CacheFiller<URI, JptInstance>(){

        public JptInstance populate(URI templateUri) {
            return new JptInstance(templateUri);
        }
    };

    private JptInstanceBuilder() {
    }

    public static JptInstance getJptInstance(URI templateUri) {
        try {
            JptInstance t = (JptInstance)JptInstanceBuilder.instance.template_cache.get((Object)templateUri, template_cache_listeners_cf);
            boolean isStale = JptInstanceBuilder.isStale(t);
            if (isStale) {
                JptInstanceBuilder.instance.template_cache.remove((Object)templateUri);
                t = (JptInstance)JptInstanceBuilder.instance.template_cache.get((Object)templateUri, template_cache_listeners_cf);
            }
            return t;
        }
        catch (Throwable e) {
            try {
                JptInstanceBuilder.instance.template_cache.remove((Object)templateUri);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static JptInstance getJptInstance(InputStream in_io, String resourcePath) {
        return new JptInstance(in_io, resourcePath);
    }

    private static boolean isStale(JptInstance jpt) {
        if (JptConfiguration.checkModified()) {
            try {
                ArrayList<Dependency> dependecies = jpt.getDependecies();
                for (Dependency dependency : dependecies) {
                    if (new File(dependency.getUri()).lastModified() <= dependency.getLastModified()) continue;
                    return true;
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                return true;
            }
        }
        return false;
    }
}

