/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.jpt.JptNode;
import org.caudexorigo.jpt.JptParentNode;
import org.caudexorigo.jpt.RepeatElements;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class JptLoopNode
extends JptParentNode {
    private boolean _isInSlot;
    private RepeatElements _repeatElements;
    private Serializable _compiled_exp;

    JptLoopNode(RepeatElements repeatElements, boolean isInSlot) {
        this._repeatElements = repeatElements;
        this._isInSlot = isInSlot;
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        if (this._compiled_exp == null) {
            ParserContext parser_context = ParserContext.create();
            Set<Map.Entry<String, Object>> ctx_entries = context.entrySet();
            for (Map.Entry<String, Object> entry : ctx_entries) {
                parser_context.addInput(entry.getKey(), entry.getValue().getClass());
            }
            this._compiled_exp = MVEL.compileExpression((String)this._repeatElements.getLoopSourceExpression(), (ParserContext)parser_context);
        }
        int child_count = this.getChildCount();
        int increment = this._repeatElements.getLoopIncrement();
        String loopVar = this._repeatElements.getLoopVar();
        String pad = this._repeatElements.getPadding();
        try {
            Object collection = MVEL.executeExpression((Object)this._compiled_exp, context);
            if (collection == null) {
                this.arrayLoop(context, out, new Object[0], child_count, increment, loopVar, pad);
                return;
            }
            if (collection.getClass().isArray()) {
                this.arrayLoop(context, out, (Object[])collection, child_count, increment, loopVar, pad);
                return;
            }
            if (collection instanceof Collection) {
                this.collectionLoop(context, out, (Collection)collection, child_count, increment, loopVar, pad);
                return;
            }
            if (collection instanceof Iterable) {
                this.iterableLoop(context, out, (Iterable)collection, child_count, increment, loopVar, pad);
                return;
            }
            if (collection instanceof Iterator) {
                this.iteratorLoop(context, out, (Iterator)collection, child_count, increment, loopVar, pad);
                return;
            }
            this.arrayLoop(context, out, new Object[0], child_count, increment, loopVar, pad);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            throw new RuntimeException(String.format("Error processing JptLoopNode:%nexpression: '%s';%ncontext: %s;%nmessage: '%s'", loopVar, context, r.getMessage()));
        }
    }

    private void arrayLoop(Map<String, Object> context, Writer out, Object[] items, int child_count, int increment, String loopVar, String pad) throws IOException {
        this.checkAllowed(context, loopVar);
        for (int n = 0; n < items.length; n += increment) {
            context.put(loopVar, items[n]);
            context.put("$index", n + 1);
            context.put("$length", items.length);
            for (int i = 0; i < child_count; ++i) {
                JptNode jpt_node = this.getChild(i);
                jpt_node.render(context, out);
            }
            if (n >= items.length - 1) continue;
            out.write(pad);
        }
        context.remove(loopVar);
        context.remove("$index");
        context.remove("$length");
    }

    private void iteratorLoop(Map<String, Object> context, Writer out, Iterator items, int child_count, int increment, String loopVar, String pad) throws IOException {
        int len = -1;
        if (context.containsKey("$length")) {
            len = (Integer)context.get("$length");
        }
        int index = 0;
        this.checkAllowed(context, loopVar);
        while (items.hasNext()) {
            Object item = items.next();
            if (++index % increment != 0) continue;
            context.put(loopVar, item);
            context.put("$index", index);
            context.put("$length", len);
            for (int i = 0; i < child_count; ++i) {
                JptNode jpt_node = this.getChild(i);
                jpt_node.render(context, out);
            }
            out.write(pad);
            context.remove(loopVar);
        }
        context.remove(loopVar);
        context.remove("$index");
        context.remove("$length");
    }

    private void iterableLoop(Map<String, Object> context, Writer out, Iterable items, int child_count, int increment, String loopVar, String pad) throws IOException {
        if (items != null) {
            this.iteratorLoop(context, out, items.iterator(), child_count, increment, loopVar, pad);
        }
    }

    private void collectionLoop(Map<String, Object> context, Writer out, Collection items, int child_count, int increment, String loopVar, String pad) throws IOException {
        if (items != null) {
            context.put("$length", items.size());
            this.iteratorLoop(context, out, items.iterator(), child_count, increment, loopVar, pad);
        }
    }

    @Override
    boolean isLoopNode() {
        return true;
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }
}

