/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.jpt.JptNode;
import org.caudexorigo.jpt.JptParentNode;
import org.mvel2.MVEL;
import org.mvel2.PropertyAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JptMacroNode
extends JptParentNode {
    private static final Logger log = LoggerFactory.getLogger(JptMacroNode.class);
    private boolean _isInSlot;
    private final String _ctx_object_type;
    private final Map<String, String> _macroParams;
    private final URI _muri;
    private final String _tmpl;

    public JptMacroNode(URI muri, String ctx_object_type, boolean isInSlot, Map<String, String> macroParams) {
        this._muri = muri;
        this._ctx_object_type = ctx_object_type;
        this._isInSlot = isInSlot;
        this._macroParams = macroParams;
        this._tmpl = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)this._muri.toString(), (String)"?"), (String)"/");
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }

    @Override
    boolean isMacroNode() {
        return true;
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        HashMap<String, Object> originalContext = new HashMap<String, Object>();
        originalContext.putAll(context);
        HashMap<String, Object> macroContext = new HashMap<String, Object>();
        Set<Map.Entry<String, String>> param_entries = this._macroParams.entrySet();
        for (Map.Entry<String, String> entry : param_entries) {
            if ("macro".equals(entry.getKey())) continue;
            try {
                Object value = MVEL.eval((String)((String)entry.getValue()).toString(), context);
                macroContext.put((String)entry.getKey(), value);
            }
            catch (PropertyAccessException t) {
                log.warn(String.format("%nPropertyAccessException for parameter value: '%s' in template '%s'. Using the value as string.%nRender context: %s%n%n", entry.getValue(), this._tmpl, context.toString()));
                macroContext.put((String)entry.getKey(), entry.getValue());
            }
        }
        originalContext.putAll(macroContext);
        Set<String> keys = context.keySet();
        for (String key : keys) {
            if (key.equals("$this")) {
                macroContext.put("$parent", context.get(key));
                continue;
            }
            macroContext.put(key, context.get(key));
        }
        try {
            Object oCtx = Class.forName(this._ctx_object_type).newInstance();
            macroContext.put("$this", oCtx);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        try {
            int child_count = this.getChildCount();
            for (int i = 0; i < child_count; ++i) {
                JptNode jpt_node = this.getChild(i);
                if (jpt_node.isInSlot()) {
                    jpt_node.render(originalContext, out);
                    continue;
                }
                jpt_node.render(macroContext, out);
            }
        }
        catch (Throwable t) {
            String s = String.format("Error during the processing of '%s'", this._muri);
            log.error(s);
            throw new RuntimeException(s, t);
        }
    }

    public String getMacroTemplate() {
        return this._tmpl;
    }
}

