/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.jpt.BaseJptNodeBuilder;
import org.caudexorigo.jpt.ContextBuilder;
import org.caudexorigo.jpt.Dependency;
import org.caudexorigo.jpt.JptAttributeNode;
import org.caudexorigo.jpt.JptConditionalAttributeNode;
import org.caudexorigo.jpt.JptConditionalNode;
import org.caudexorigo.jpt.JptDocument;
import org.caudexorigo.jpt.JptHolderNode;
import org.caudexorigo.jpt.JptIncludeNode;
import org.caudexorigo.jpt.JptLoopNode;
import org.caudexorigo.jpt.JptMacroNode;
import org.caudexorigo.jpt.JptOutputExpressionNode;
import org.caudexorigo.jpt.JptParentNode;
import org.caudexorigo.jpt.JptStaticFragment;
import org.caudexorigo.jpt.JptTemplateNode;
import org.caudexorigo.jpt.RepeatElements;
import org.caudexorigo.xom.XomDocumentBuilder;
import org.caudexorigo.xom.XomUtils;

public class JptNodeBuilder
extends BaseJptNodeBuilder {
    private static final String METAL_NS = "http://xml.zope.org/namespaces/metal";
    private static final String TAL_NS = "http://xml.zope.org/namespaces/tal";
    private static final String APPEND_SLOT_NS = "http://xml.zope.org/namespaces/metal/append-to-slot";
    private URI _templateUri;
    private JptDocument _jptDocument;
    private StringBuilder _sb;
    private ArrayList<Element> _slotFillerList = new ArrayList();
    private ArrayList<Element> _slotAppenderList = new ArrayList();
    private ArrayList<Dependency> _dependecies = new ArrayList();
    private Deque<JptParentNode> pnodes = new ArrayDeque<JptParentNode>();
    private Map<String, Element> slotFillers = new HashMap<String, Element>();
    private Map<String, Element> slotAppenders = new HashMap<String, Element>();
    private boolean _isInSlot = false;

    public JptNodeBuilder() {
        this(new StringBuilder());
    }

    private JptNodeBuilder(StringBuilder sb) {
        super(sb);
        this._sb = sb;
    }

    public JptDocument getJptDocument() {
        return this._jptDocument;
    }

    private void prepareElement(Element el) throws ValidityException, ParsingException, IOException {
        if (XomUtils.getAttribute(el, "metal:use-macro") != null) {
            this.processMetalUseMacro(el);
            return;
        }
        if (XomUtils.getAttribute(el, "metal:define-slot") != null) {
            this.processMetalDefineSlot(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:condition") != null) {
            this.processTalCondition(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:repeat") != null) {
            this.processTalRepeat(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:content") != null) {
            this.processTalContent(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:replace") != null) {
            this.processTalReplace(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:include") != null) {
            this.processTalInclude(el);
            return;
        }
        if (XomUtils.getAttribute(el, "tal:omit-tag") != null) {
            this.processTalOmitTag(el);
            return;
        }
        if ("template".equals(el.getLocalName()) && TAL_NS.equals(el.getNamespaceURI())) {
            this.processTalTemplate(el);
            return;
        }
        if (XomUtils.getAttribute(el, "metal:fill-slot") != null) {
            el.removeAttribute(XomUtils.getAttribute(el, "metal:fill-slot"));
        }
        if (XomUtils.getAttribute(el, "metal:define-macro") != null) {
            el.removeAttribute(XomUtils.getAttribute(el, "metal:define-macro"));
        }
        super.process(el);
    }

    private void processTalTemplate(Element el) {
        this.addStaticFragments();
        StringBuilder template = new StringBuilder();
        for (int i = 0; i < el.getChildCount(); ++i) {
            template.append(el.getChild(i).toXML());
        }
        el.removeChildren();
        JptTemplateNode jout = el.getBaseURI().equals(APPEND_SLOT_NS) ? new JptTemplateNode(template.toString(), true) : new JptTemplateNode(template.toString(), this._isInSlot);
        this.removePNodeChildren();
        this.pnodes.peek().appendChild(jout);
    }

    private void processTalInclude(Element el) {
        Attribute attribute = XomUtils.getAttribute(el, "tal:include");
        if (attribute != null) {
            el.removeAttribute(attribute);
            this.addStaticFragments();
            el.removeChildren();
            JptIncludeNode jinclude = new JptIncludeNode(attribute.getValue(), this._isInSlot);
            this.removePNodeChildren();
            this.pnodes.peek().appendChild(jinclude);
        }
    }

    public void process(Document doc, URI templateUri) {
        this._templateUri = templateUri;
        this.findSlotActorsInDocument((Node)doc);
        this.prepareSlotsActorsInDocument();
        String object_class_name = ContextBuilder.objectNameFromInstructions(doc);
        this._jptDocument = new JptDocument(object_class_name);
        this.pnodes.push(this._jptDocument);
        super.process(doc);
        JptStaticFragment sf = new JptStaticFragment(this._sb.toString());
        this.pnodes.peek().appendChild(sf);
    }

    private Map<String, String> extractMacroParams(String uri_qs) {
        try {
            String[] pairs;
            HashMap<String, String> query_pairs = new HashMap<String, String>();
            for (String pair : pairs = uri_qs.split("&")) {
                int idx = pair.indexOf("=");
                query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
            return query_pairs;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void findSlotActorsInDocument(Node node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i) instanceof Element) {
                String slot_to_append_name;
                Element element = (Element)node.getChild(i);
                String slot_filler_name = element.getAttributeValue("fill-slot", METAL_NS);
                if (slot_filler_name != null) {
                    this._slotFillerList.add(element);
                }
                if ((slot_to_append_name = element.getAttributeValue("append-to-slot", METAL_NS)) != null) {
                    this._slotAppenderList.add(element);
                }
            }
            this.findSlotActorsInDocument(node.getChild(i));
        }
    }

    private void prepareSlotsActorsInDocument() {
        Element[] slot_filler_elements = this._slotFillerList.toArray(new Element[0]);
        for (int i = 0; i < slot_filler_elements.length; ++i) {
            Element element = slot_filler_elements[i];
            String slot_to_fill_name = element.getAttributeValue("fill-slot", METAL_NS);
            this.slotFillers.put(slot_to_fill_name, (Element)element.copy());
        }
        Element[] slot_appender_elements = this._slotAppenderList.toArray(new Element[0]);
        for (int i = 0; i < slot_appender_elements.length; ++i) {
            Element element = slot_appender_elements[i];
            String slot_to_fill_name = element.getAttributeValue("append-to-slot", METAL_NS);
            this.slotAppenders.put(slot_to_fill_name, (Element)element.copy());
        }
    }

    private void prepareMacro(URI muri, Document macroDocument, Node useMacroNode, String macroPath, Map<String, String> macroParams) throws ValidityException, ParsingException, IOException {
        String macroName = macroParams.get("macro");
        Document macro_doc = macroDocument.getDocument();
        this.findSlotActorsInDocument((Node)macroDocument);
        this.prepareSlotsActorsInDocument();
        Element[] defined_macro = new Element[1];
        XomUtils.findSpecificMacro((Node)macro_doc, macroName, defined_macro);
        Element subtree = defined_macro[0];
        if (subtree == null) {
            throw new IllegalArgumentException(String.format("could not find macro '%s' in template '%s'", macroName, macroPath));
        }
        String object_class_name = ContextBuilder.objectNameFromInstructions(macro_doc);
        JptMacroNode jpt_macro_node = new JptMacroNode(muri, object_class_name, this._isInSlot, macroParams);
        this.addStaticFragments();
        this.pnodes.push(jpt_macro_node);
        this._isInSlot = false;
        this.prepareElement(subtree);
        this.pnodes.pop();
        this.pnodes.peek().appendChild(jpt_macro_node);
    }

    @Override
    protected void process(Element element) {
        try {
            this.prepareElement(element);
        }
        catch (ValidityException e) {
            e.printStackTrace();
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void processAttributes(Element element) {
        this.processTalAttributes(element);
        super.processAttributes(element);
    }

    private void processTalAttributes(Element el) {
        this.processTalConditionalAttributes(el);
        Attribute attribute = XomUtils.getAttribute(el, "tal:attributes");
        if (attribute != null) {
            Attribute[] tal_attributes;
            el.removeAttribute(attribute);
            for (Attribute tal_attribute : tal_attributes = XomUtils.processTalAttributes(attribute)) {
                Attribute attr_to_remove = el.getAttribute(tal_attribute.getLocalName());
                if (attr_to_remove == null) continue;
                el.removeAttribute(attr_to_remove);
            }
            this.addStaticFragments();
            for (Attribute tal_attribute : tal_attributes) {
                JptAttributeNode jattr = new JptAttributeNode(tal_attribute, this._isInSlot);
                this.pnodes.peek().appendChild(jattr);
            }
        }
    }

    private void processTalConditionalAttributes(Element el) {
        Attribute attribute0 = XomUtils.getAttribute(el, "tal:conditional-attributes");
        Attribute attribute1 = XomUtils.getAttribute(el, "tal:conditionalAttributes");
        Attribute attribute = JptNodeBuilder.coalesce(attribute0, attribute1);
        if (attribute != null) {
            Attribute[] tal_attributes;
            el.removeAttribute(attribute);
            for (Attribute tal_attribute : tal_attributes = XomUtils.processTalAttributes(attribute)) {
                Attribute attr_to_remove = el.getAttribute(tal_attribute.getLocalName());
                if (attr_to_remove == null) continue;
                el.removeAttribute(attr_to_remove);
            }
            this.addStaticFragments();
            for (Attribute tal_attribute : tal_attributes) {
                JptConditionalAttributeNode jattr = new JptConditionalAttributeNode(tal_attribute, this._isInSlot);
                this.pnodes.peek().appendChild(jattr);
            }
        }
    }

    private void processTalCondition(Element el) {
        Attribute attribute = XomUtils.getAttribute(el, "tal:condition");
        if (attribute != null) {
            String current_attribute_value = attribute.getValue();
            this.addStaticFragments();
            el.removeAttribute(attribute);
            JptConditionalNode jcond = new JptConditionalNode(current_attribute_value, this._isInSlot);
            this.pnodes.push(jcond);
            this.process(el);
            this.addStaticFragments();
            this.pnodes.pop();
            this.pnodes.peek().appendChild(jcond);
        }
    }

    private void processTalOmitTag(Element el) {
        Attribute omit_tag_attr = XomUtils.getAttribute(el, "tal:omit-tag");
        if (omit_tag_attr != null) {
            el.removeAttribute(omit_tag_attr);
            this.addStaticFragments();
            String omit_tag_condition = StringUtils.isBlank((CharSequence)omit_tag_attr.getValue()) ? "false" : String.format("!%s", omit_tag_attr.getValue());
            JptHolderNode holder_node = new JptHolderNode(this._isInSlot);
            this.pnodes.peek().appendChild(holder_node);
            this.pnodes.push(holder_node);
            JptConditionalNode start_cond = new JptConditionalNode(omit_tag_condition, this._isInSlot);
            this.pnodes.push(start_cond);
            this.processStartTag(el);
            this.addStaticFragments();
            this.pnodes.pop();
            this.pnodes.peek().appendChild(start_cond);
            int child_count = el.getChildCount();
            for (int i = 0; i < child_count; ++i) {
                Node c = el.getChild(i);
                this.processChild(c);
            }
            this.addStaticFragments();
            JptConditionalNode end_cond = new JptConditionalNode(omit_tag_condition, this._isInSlot);
            this.pnodes.push(end_cond);
            this.processEndTag(el);
            this.addStaticFragments();
            this.pnodes.pop();
            this.pnodes.peek().appendChild(end_cond);
            this.pnodes.pop();
        } else {
            this.process(el);
        }
    }

    private void addStaticFragments() {
        JptStaticFragment sf = new JptStaticFragment(this._sb.toString());
        JptParentNode parent = this.pnodes.peek();
        parent.appendChild(sf);
        this._sb.delete(0, this._sb.length());
    }

    private void processTalContent(Element el) {
        Attribute attribute = XomUtils.getAttribute(el, "tal:content");
        if (attribute != null) {
            el.removeAttribute(attribute);
            this.addStaticFragments();
            Attribute omit_tag_attr = XomUtils.getAttribute(el, "tal:omit-tag");
            if (omit_tag_attr != null) {
                el.removeAttribute(omit_tag_attr);
                String omit_tag_condition = StringUtils.isBlank((CharSequence)omit_tag_attr.getValue()) ? "false" : String.format("!%s", omit_tag_attr.getValue());
                JptHolderNode holder_node = new JptHolderNode(this._isInSlot);
                this.pnodes.peek().appendChild(holder_node);
                this.pnodes.push(holder_node);
                JptConditionalNode start_cond = new JptConditionalNode(omit_tag_condition, this._isInSlot);
                this.pnodes.push(start_cond);
                this.processStartTag(el);
                this.addStaticFragments();
                this.pnodes.pop();
                this.pnodes.peek().appendChild(start_cond);
                this.pnodes.pop();
            } else {
                this.removePNodeChildren();
                this.processStartTag(el);
            }
            this.addStaticFragments();
            this.processTalAttributes(el);
            JptOutputExpressionNode jout = el.getBaseURI().equals(APPEND_SLOT_NS) ? new JptOutputExpressionNode(attribute.getValue(), true) : new JptOutputExpressionNode(attribute.getValue(), this._isInSlot);
            this.pnodes.peek().appendChild(jout);
            if (omit_tag_attr != null) {
                String omit_tag_condition = StringUtils.isBlank((CharSequence)omit_tag_attr.getValue()) ? "false" : String.format("!%s", omit_tag_attr.getValue());
                JptConditionalNode end_cond = new JptConditionalNode(omit_tag_condition, this._isInSlot);
                this.pnodes.push(end_cond);
                this.processEndTag(el);
                this.addStaticFragments();
                this.pnodes.pop();
                this.pnodes.peek().appendChild(end_cond);
            } else {
                this.processEndTag(el);
            }
            el.removeChildren();
            this.addStaticFragments();
        }
    }

    private void processMetalUseMacro(Element el) throws ValidityException, ParsingException, IOException {
        Attribute attribute = XomUtils.getAttribute(el, "metal:use-macro");
        if (attribute != null) {
            el.removeAttribute(attribute);
            String use_macro_value = attribute.getValue();
            URI macroURI = this._templateUri.resolve(use_macro_value);
            String macroPath = macroURI.getPath();
            URI macroUri = this._templateUri.resolve(macroPath);
            Dependency d = new Dependency(macroUri);
            this._dependecies.add(d);
            Map<String, String> macroParams = this.extractMacroParams(macroURI.getRawQuery());
            Document document_macro = XomDocumentBuilder.getDocument(macroUri);
            this.prepareMacro(macroURI, document_macro, (Node)el, macroPath, macroParams);
        }
    }

    private void childAppender(Element root, Node child) {
        if (child == null) {
            return;
        }
        root.setBaseURI(APPEND_SLOT_NS);
        int appendChildCount = child.getChildCount();
        for (int i = 0; i < appendChildCount; ++i) {
            Node childNode = child.copy().getChild(i);
            if (childNode == null) continue;
            childNode.detach();
            root.appendChild(childNode);
            if (!(childNode instanceof Element)) continue;
            Element rchild = (Element)child;
            rchild.setBaseURI(APPEND_SLOT_NS);
            int arChildCount = rchild.getChildCount();
            for (int j = 0; j < arChildCount; ++j) {
                this.childAppender(rchild, rchild.getChild(j));
            }
        }
    }

    private void processMetalDefineSlot(Element el) throws ValidityException, ParsingException, IOException {
        Attribute attribute = XomUtils.getAttribute(el, "metal:define-slot");
        if (attribute != null) {
            Element slot_filler_element;
            el.removeAttribute(attribute);
            String current_attribute_value = attribute.getValue();
            Element slot_appender_element = this.slotAppenders.get(current_attribute_value);
            if (slot_appender_element != null) {
                slot_appender_element.detach();
                this.childAppender(el, (Node)slot_appender_element);
            }
            if ((slot_filler_element = this.slotFillers.get(current_attribute_value)) != null) {
                this._isInSlot = true;
                this.prepareElement(slot_filler_element);
                this._isInSlot = false;
                return;
            }
            this.prepareElement(el);
        }
    }

    private void processTalRepeat(Element el) {
        Attribute attribute = XomUtils.getAttribute(el, "tal:repeat");
        if (attribute != null) {
            el.removeAttribute(attribute);
            String current_attribute_value = attribute.getValue();
            this.addStaticFragments();
            String padding = "";
            RepeatElements relements = new RepeatElements(current_attribute_value, padding);
            JptLoopNode jloop = new JptLoopNode(relements, this._isInSlot);
            this.pnodes.push(jloop);
            this.process(el);
            this.addStaticFragments();
            this.processTalReplace(el);
            this.processTalContent(el);
            this.pnodes.pop();
            this.pnodes.peek().appendChild(jloop);
        }
    }

    private void processTalReplace(Element el) {
        Attribute attribute = XomUtils.getAttribute(el, "tal:replace");
        if (attribute != null) {
            el.removeAttribute(attribute);
            this.addStaticFragments();
            el.removeChildren();
            JptOutputExpressionNode jout = el.getBaseURI().equals(APPEND_SLOT_NS) ? new JptOutputExpressionNode(attribute.getValue(), true) : new JptOutputExpressionNode(attribute.getValue(), this._isInSlot);
            this.removePNodeChildren();
            this.pnodes.peek().appendChild(jout);
        }
    }

    private void removePNodeChildren() {
    }

    public ArrayList<Dependency> getDependecies() {
        return this._dependecies;
    }
}

