/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.jpt.JptNode;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class JptOutputExpressionNode
extends JptNode {
    private static final String TEXT = "text ";
    private static final String STRUCTURE = "structure ";
    private boolean _isInSlot;
    private Serializable _compiled_exp;
    private final boolean escape;
    private String _evaluation_exp;

    JptOutputExpressionNode(String jpt_exp, boolean isInSlot) {
        this._isInSlot = isInSlot;
        if (StringUtils.isBlank((CharSequence)jpt_exp)) {
            throw new IllegalArgumentException("tal expression can not be blank");
        }
        this._evaluation_exp = jpt_exp;
        if (jpt_exp.startsWith(TEXT)) {
            this.escape = true;
            this._evaluation_exp = jpt_exp.substring(TEXT.length());
        } else if (jpt_exp.startsWith(STRUCTURE)) {
            this.escape = false;
            this._evaluation_exp = jpt_exp.substring(STRUCTURE.length());
        } else {
            this.escape = true;
        }
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public JptNode getChild(int i) {
        throw new IndexOutOfBoundsException("Output Expressions do not have children");
    }

    @Override
    public void render(Map<String, Object> context, Writer out) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException("render context can not be null");
        }
        String result = null;
        try {
            if (this._compiled_exp == null) {
                ParserContext parser_context = ParserContext.create();
                Set<Map.Entry<String, Object>> ctx_entries = context.entrySet();
                for (Map.Entry<String, Object> entry : ctx_entries) {
                    parser_context.addInput(entry.getKey(), entry.getValue().getClass());
                }
                this._compiled_exp = MVEL.compileExpression((String)this._evaluation_exp, (ParserContext)parser_context);
            }
            result = String.valueOf(MVEL.executeExpression((Object)this._compiled_exp, context));
            String sout = this.escape ? StringEscapeUtils.escapeXml((String)result) : result;
            out.write(sout);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            throw new RuntimeException(String.format("Error processing JptOutputExpressionNode:%nexpression: '%s';%ncontext: %s;%nmessage: '%s'", this._evaluation_exp, context, r.getMessage()));
        }
    }

    @Override
    public boolean isInSlot() {
        return this._isInSlot;
    }
}

