/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.jpt;

import java.util.Map;
import org.caudexorigo.jpt.JptNode;

public abstract class JptParentNode
extends JptNode {
    JptNode[] children;
    int childCount = 0;
    String actualBaseURI;

    JptParentNode() {
    }

    @Override
    public int getChildCount() {
        return this.childCount;
    }

    public void insertChild(JptNode child, int position) {
        this._insertChild(child, position);
    }

    final void _insertChild(JptNode child, int position) {
        this.insertionAllowed(child, position);
        this.fastInsertChild(child, position);
    }

    void fastInsertChild(JptNode child, int position) {
        this.checkCapacity(this.childCount + 1);
        if (position < this.childCount) {
            System.arraycopy(this.children, position, this.children, position + 1, this.childCount - position);
        }
        this.children[position] = child;
        ++this.childCount;
        child.setParent(this);
    }

    private void checkCapacity(int position) {
        if (this.children == null) {
            this.children = new JptNode[1];
        } else if (position >= this.children.length) {
            JptNode[] data = new JptNode[this.children.length * 2];
            System.arraycopy(this.children, 0, data, 0, this.children.length);
            this.children = data;
        }
    }

    void insertionAllowed(JptNode child, int position) {
        if (child == null) {
            throw new NullPointerException("Tried to insert a null child in the document");
        }
        if (child.getParent() != null) {
            throw new IllegalStateException("Child already has a parent.");
        }
    }

    public void appendChild(JptNode child) {
        this.insertChild(child, this.childCount);
    }

    @Override
    public JptNode getChild(int position) {
        return this.children[position];
    }

    public int indexOf(JptNode child) {
        if (this.children == null) {
            return -1;
        }
        for (int i = 0; i < this.childCount; ++i) {
            if (child != this.children[i]) continue;
            return i;
        }
        return -1;
    }

    public JptNode removeChild(int position) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("This node has no children");
        }
        JptNode removed = this.children[position];
        int toCopy = this.childCount - position - 1;
        if (toCopy > 0) {
            System.arraycopy(this.children, position + 1, this.children, position, toCopy);
        }
        --this.childCount;
        this.children[this.childCount] = null;
        removed.setParent(null);
        return removed;
    }

    @Override
    final boolean isParentNode() {
        return true;
    }

    protected void checkAllowed(Map<String, Object> context, String variable) {
        if (context.get(variable) != null) {
            throw new IllegalStateException(String.format("Variable '%s' is already in context", variable));
        }
    }
}

