/*
 * Decompiled with CFR 0.152.
 */
package org.caudexorigo.xom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import nu.xom.XMLException;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.jpt.JptConfiguration;
import org.caudexorigo.jpt.JptNotFoundException;
import org.caudexorigo.xom.XhtmlEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XomDocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(XomDocumentBuilder.class);
    private static String[] parsers = new String[]{"org.apache.xerces.parsers.SAXParser", "com.sun.org.apache.xerces.internal.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "org.apache.crimson.parser.XMLReaderImpl", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "com.jclark.xml.sax.SAX2Driver", "net.sf.saxon.aelfred.SAXDriver", "com.icl.saxon.aelfred.SAXDriver", "org.dom4j.io.aelfred2.SAXDriver", "org.dom4j.io.aelfred.SAXDriver"};
    private static final XMLReader reader = StringUtils.isBlank((CharSequence)JptConfiguration.xmlReaderClass()) ? XomDocumentBuilder.findParser() : XomDocumentBuilder.createParser(JptConfiguration.xmlReaderClass());

    static XMLReader createParser(String parserClass) {
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader(parserClass);
            return parser;
        }
        catch (Exception ex) {
            throw new XMLException(parserClass + " not found or not a a suitable SAX2 parser", (Throwable)ex);
        }
    }

    static XMLReader findParser() {
        for (int i = 0; i < parsers.length; ++i) {
            try {
                XMLReader parser = XMLReaderFactory.createXMLReader(parsers[i]);
                try {
                    parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
                    parser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                    parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return parser;
            }
            catch (SAXException sAXException) {
                continue;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            return parser;
        }
        catch (SAXException ex) {
            throw new XMLException("Could not find a suitable SAX2 parser", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(InputStream in) throws ValidityException, ParsingException, IOException {
        XMLReader xMLReader = reader;
        synchronized (xMLReader) {
            if (reader == null) {
                XMLReader singularity_reader = XomDocumentBuilder.findParser();
                Builder builder = new Builder(singularity_reader, false);
                return builder.build(in);
            }
            Builder builder = new Builder(reader, false);
            return builder.build(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(URI templateUri) throws ValidityException, ParsingException, IOException {
        FileInputStream fis;
        if (log.isDebugEnabled()) {
            log.debug("building document: {}", (Object)templateUri.toString());
        }
        File ftemplate = new File(templateUri);
        try {
            fis = new FileInputStream(ftemplate);
        }
        catch (FileNotFoundException e) {
            throw new JptNotFoundException(e);
        }
        XMLReader xMLReader = reader;
        synchronized (xMLReader) {
            Builder builder = new Builder(reader, false);
            return builder.build((InputStream)fis);
        }
    }

    private XomDocumentBuilder() {
    }

    static {
        if (reader == null) {
            throw new RuntimeException("Unable to create XMLReader");
        }
        reader.setEntityResolver(new XhtmlEntityResolver());
    }
}

