/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.Categories;
import pt.sapo.sapofe.api.MainMenuApiList;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = -3173774769371117459L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private static NewsDb instance = new NewsDb();
    private MainMenuApiList menus;
    private Map<String, Categories> categoriesBySlug;
    private Map<String, CanaisAPI> partnersBySlug;
    private Map<String, CanaisAPI> authorsBySlug;
    private Map<String, CanaisAPI> itemBySlug;
    private Map<String, CanaisAPI> itemByUrl;
    private Date lastModified = new Date();

    private NewsDb() {
        String projectName = System.getProperty("project", null);
        String fileName = "./" + (projectName != null ? projectName + "-" : "") + "news.db";
        File adbFile = new File(fileName);
        if (adbFile.exists()) {
            try (FileInputStream fis = new FileInputStream(adbFile);
                 ObjectInputStream in = new ObjectInputStream(fis);){
                NewsDb ard = (NewsDb)in.readObject();
                this.init(ard.doGetMenus(), ard.doGetCategories(), ard.doGetPartners(), ard.doGetAuthors(), ard.doGetAllItemByUrl(), ard.doGetAllItemBySlug());
            }
            catch (Throwable t) {
                Shutdown.now((Throwable)t);
            }
        } else {
            this.init(new MainMenuApiList(), new HashMap<String, Categories>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>());
        }
    }

    private static synchronized void dump(NewsDb adb) {
        File outFile = new File("./news.db.tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            String projectName = System.getProperty("project", null);
            String fileName = "./" + (projectName != null ? projectName + "-" : "") + "news.db";
            File dstFile = new File(fileName);
            Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void build(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, CanaisAPI> _lstPagesBySlug) {
        NewsDb adb = new NewsDb(_menus, _lstCategories, _lstPartners, _lstAuthors, _lstPagesByUrl, _lstPagesBySlug);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        log.info("build(InputStream input)");
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adb = (NewsDb)in.readObject();
            NewsDb.dump(adb);
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public NewsDb(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, CanaisAPI> _lstPagesBySlug) {
        this.init(_menus, _lstCategories, _lstPartners, _lstAuthors, _lstPagesByUrl, _lstPagesBySlug);
    }

    private void init(MainMenuApiList _menus, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, CanaisAPI> _lstPagesBySlug) {
        this.menus = _menus;
        this.categoriesBySlug = new HashMap<String, Categories>();
        this.partnersBySlug = new HashMap<String, CanaisAPI>();
        this.authorsBySlug = new HashMap<String, CanaisAPI>();
        this.itemByUrl = new HashMap<String, CanaisAPI>();
        this.itemBySlug = new HashMap<String, CanaisAPI>();
        this.fillLookupTables(_lstCategories, _lstPartners, _lstAuthors, _lstPagesByUrl, _lstPagesBySlug);
        this.lastModified = new Date();
    }

    private void fillLookupTables(Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstPagesByUrl, Map<String, CanaisAPI> _lstPagesBySlug) {
        this.categoriesBySlug = _lstCategories;
        this.partnersBySlug = _lstPartners;
        this.authorsBySlug = _lstAuthors;
        this.itemBySlug = _lstPagesBySlug;
        this.itemByUrl = _lstPagesByUrl;
    }

    public static final MainMenuApiList getMenus() {
        return instance.doGetMenus();
    }

    public static final Map<String, Categories> getCategories() {
        return instance.doGetCategories();
    }

    public static final Map<String, CanaisAPI> getPartners() {
        return instance.doGetPartners();
    }

    public static final Map<String, CanaisAPI> getAuthors() {
        return instance.doGetAuthors();
    }

    public static final CanaisAPI getItemBySlug(String slug) {
        return instance.doGetItemBySlug(slug);
    }

    public static final Map<String, CanaisAPI> getAllItemBySlug() {
        return instance.doGetAllItemBySlug();
    }

    public static final CanaisAPI getItemByUrl(String url) {
        return instance.doGetItemByUrl(url);
    }

    public static final Map<String, CanaisAPI> getAllItemByUrl() {
        return instance.doGetAllItemByUrl();
    }

    private MainMenuApiList doGetMenus() {
        return this.menus;
    }

    private Map<String, Categories> doGetCategories() {
        return this.categoriesBySlug;
    }

    private Map<String, CanaisAPI> doGetPartners() {
        return this.partnersBySlug;
    }

    private Map<String, CanaisAPI> doGetAuthors() {
        return this.authorsBySlug;
    }

    private Map<String, CanaisAPI> doGetAllItemBySlug() {
        return this.itemBySlug;
    }

    private CanaisAPI doGetItemBySlug(String slug) {
        return this.itemBySlug.get(slug);
    }

    private Map<String, CanaisAPI> doGetAllItemByUrl() {
        return this.itemByUrl;
    }

    private CanaisAPI doGetItemByUrl(String url) {
        return this.itemByUrl.get(url);
    }

    public static final Date getLastModified() {
        return instance.doGetLastModified();
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static Object getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }
}

