/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.caudexorigo.text.DateUtil;
import pt.sapo.sapofe.api.Headlines;
import pt.sapo.sapofe.api.Location;
import pt.sapo.sapofe.api.Periodicity;
import pt.sapo.sapofe.api.Producer;
import pt.sapo.sapofe.api.RawImage;
import pt.sapo.sapofe.api.Source;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Newspaper
implements Serializable {
    private static final long serialVersionUID = 5645176040629209295L;
    @JsonProperty(value="_id")
    private String id;
    @JsonProperty(value="DateTime")
    private String date;
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="Source")
    private Source source;
    @JsonProperty(value="RawImage")
    private RawImage rawImage;
    @JsonProperty(value="Periodicity")
    private Periodicity periodicity;
    @JsonProperty(value="Location")
    private Location[] location;
    @JsonProperty(value="Headlines")
    private List<Headlines> headlines;
    @JsonProperty(value="Producer")
    private Producer producer;
    private String url;
    private String archiveUrl;
    private String shareUrl;

    public String getId() {
        return this.id;
    }

    public String getDate() {
        return this.date;
    }

    public String getTitle() {
        return this.title;
    }

    public Source getSource() {
        return this.source;
    }

    public RawImage getRawImage() {
        return this.rawImage;
    }

    public Periodicity getPeriodicity() {
        return this.periodicity;
    }

    public Location[] getLocation() {
        return this.location;
    }

    public List<Headlines> getHeadlines() {
        return this.headlines;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveUrl() {
        return this.archiveUrl;
    }

    public String getShareUrl() {
        return this.shareUrl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDate(String date) {
        this.date = new SimpleDateFormat("yyyy-MM-dd k:m:s", new Locale("pt")).format(DateUtil.parseISODate((String)date).getTime());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setRawImage(RawImage rawImage) {
        this.rawImage = rawImage;
    }

    public void setPeriodicity(Periodicity periodicity) {
        this.periodicity = periodicity;
    }

    public void setLocation(Location[] location) {
        this.location = location;
    }

    public void setHeadlines(List<Headlines> headlines) {
        this.headlines = headlines;
    }

    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
    }

    public void setShareUrl(String shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String toString() {
        return "Newspaper [id=" + this.id + ", date=" + this.date + ", title=" + this.title + ", source=" + this.source + ", rawImage=" + this.rawImage + ", periodicity=" + this.periodicity + ", location=" + Arrays.toString(this.location) + ", headlines=" + this.headlines + ", producer=" + this.producer + ", url=" + this.url + ", archiveUrl=" + this.archiveUrl + ", shareUrl=" + this.shareUrl + "]";
    }
}

