/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Writer;
import org.caudexorigo.io.UnsynchronizedStringWriter;

public class JsonConverter<T> {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Class<T> clazz;

    public JsonConverter(Class<T> clazz) {
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.clazz = clazz;
    }

    public void toJson(T object, Writer out) {
        try {
            mapper.writeValue(out, object);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String toJsonString(T object) {
        try {
            UnsynchronizedStringWriter w = new UnsynchronizedStringWriter();
            this.toJson(object, (Writer)w);
            return w.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public T fromJson(byte[] json) {
        try {
            Object ev = mapper.readValue(json, this.clazz);
            return (T)ev;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public T fromJson(String json_string) {
        try {
            Object object = mapper.readValue(json_string, this.clazz);
            return (T)object;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

