/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.sapodesporto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.caudexorigo.text.DateUtil;
import pt.sapo.sapofe.api.sapodesporto.Aggregate;
import pt.sapo.sapofe.api.sapodesporto.Channel;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsApi;
import pt.sapo.sapofe.api.sapodesporto.Status;
import pt.sapo.sapofe.api.sapodesporto.Team;
import pt.sapo.sapofe.api.sapodesporto.Venue;
import pt.sapo.sapofe.api.sapovideos.Video;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RecordItem
implements Serializable {
    private static final long serialVersionUID = -4679961187950204077L;
    @JsonProperty(value="Id")
    private int id;
    @JsonProperty(value="RoundId")
    private int roundId;
    @JsonProperty(value="RoundName")
    private String roundName;
    @JsonProperty(value="DateTime")
    private String dateTime;
    private Long dateTimeStamp;
    @JsonProperty(value="HomeTeam")
    private Team homeTeam;
    @JsonProperty(value="HomeTeamSlotName")
    private String homeTeamSlotName;
    @JsonProperty(value="HomeTeamScore")
    private int homeTeamScore;
    @JsonProperty(value="HomeTeamHalfTimeScore")
    private int homeTeamHalfTimeScore;
    @JsonProperty(value="AwayTeam")
    private Team awayTeam;
    @JsonProperty(value="AwayTeamSlotName")
    private String awayTeamSlotName;
    @JsonProperty(value="AwayTeamScore")
    private int awayTeamScore;
    @JsonProperty(value="AwayTeamHalfTimeScore")
    private int awayTeamHalfTimeScore;
    @JsonProperty(value="Venue")
    private Venue venue;
    @JsonProperty(value="Status")
    private Status status;
    @JsonProperty(value="Period")
    private Status period;
    @JsonProperty(value="Aggregate")
    private Aggregate aggregate;
    @JsonProperty(value="Channels")
    private List<Channel> channels;
    @JsonProperty(value="WinnerTeamID")
    private int winnerTeamID;
    @JsonProperty(value="Minute")
    private int minute;
    @JsonProperty(value="MinuteExtra")
    private int minuteExtra;
    @JsonProperty(value="FullCoverage")
    private boolean fullCoverage;
    @JsonProperty(value="Goals")
    private int goals;
    @JsonProperty(value="Round")
    private SportStatisticsApi round;
    private int matches;
    private List<RecordItem> lstMatches;
    @JsonProperty(value="Position")
    private int position;
    @JsonProperty(value="Rank")
    private int rank;
    @JsonProperty(value="Person")
    private SportStatisticsApi person;
    @JsonProperty(value="Team")
    private Team team;
    @JsonProperty(value="Attendance")
    private int attendance;
    @JsonProperty(value="CompetitionSeasonId")
    private int competitionSeasonId;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="FullName")
    private String fullName;
    private String disqusUrl;
    private SportStatisticsApi competition;
    private List<Video> videos;

    @JsonSetter(value="Matches")
    public void setMarchesInternal(JsonNode matchesInternal) {
        ObjectMapper mapper = new ObjectMapper();
        if (matchesInternal != null) {
            if (matchesInternal.isInt()) {
                this.matches = matchesInternal.asInt();
            } else if (matchesInternal.isArray()) {
                this.lstMatches = new ArrayList<RecordItem>();
                for (JsonNode matchInternal : matchesInternal) {
                    this.lstMatches.add((RecordItem)mapper.convertValue((Object)matchInternal, RecordItem.class));
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.disqusUrl = "/futebol/jogo/" + id;
    }

    public int getRoundId() {
        return this.roundId;
    }

    public void setRoundId(int roundId) {
        this.roundId = roundId;
    }

    public String getRoundName() {
        return this.roundName;
    }

    public void setRoundName(String roundName) {
        this.roundName = roundName;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        Date _date = DateUtil.parseISODate((String)dateTime);
        this.dateTimeStamp = _date.getTime();
        this.dateTime = dateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000000", new Locale("pt", "PT")).format(_date);
    }

    public Long getDateTimeStamp() {
        return this.dateTimeStamp;
    }

    public void setDateTimeStamp(Long dateTimeStamp) {
        this.dateTimeStamp = dateTimeStamp;
    }

    public Team getHomeTeam() {
        return this.homeTeam;
    }

    public void setHomeTeam(Team homeTeam) {
        this.homeTeam = homeTeam;
    }

    public String getHomeTeamSlotName() {
        return this.homeTeamSlotName;
    }

    public void setHomeTeamSlotName(String homeTeamSlotName) {
        this.homeTeamSlotName = homeTeamSlotName;
    }

    public int getHomeTeamScore() {
        return this.homeTeamScore;
    }

    public void setHomeTeamScore(int homeTeamScore) {
        this.homeTeamScore = homeTeamScore;
    }

    public int getHomeTeamHalfTimeScore() {
        return this.homeTeamHalfTimeScore;
    }

    public void setHomeTeamHalfTimeScore(int homeTeamHalfTimeScore) {
        this.homeTeamHalfTimeScore = homeTeamHalfTimeScore;
    }

    public Team getAwayTeam() {
        return this.awayTeam;
    }

    public void setAwayTeam(Team awayTeam) {
        this.awayTeam = awayTeam;
    }

    public String getAwayTeamSlotName() {
        return this.awayTeamSlotName;
    }

    public void setAwayTeamSlotName(String awayTeamSlotName) {
        this.awayTeamSlotName = awayTeamSlotName;
    }

    public int getAwayTeamScore() {
        return this.awayTeamScore;
    }

    public void setAwayTeamScore(int awayTeamScore) {
        this.awayTeamScore = awayTeamScore;
    }

    public int getAwayTeamHalfTimeScore() {
        return this.awayTeamHalfTimeScore;
    }

    public void setAwayTeamHalfTimeScore(int awayTeamHalfTimeScore) {
        this.awayTeamHalfTimeScore = awayTeamHalfTimeScore;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getPeriod() {
        return this.period;
    }

    public void setPeriod(Status period) {
        this.period = period;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public int getGoals() {
        return this.goals;
    }

    public void setGoals(int goals) {
        this.goals = goals;
    }

    public SportStatisticsApi getRound() {
        return this.round;
    }

    public void setRound(SportStatisticsApi round) {
        this.round = round;
    }

    public int getWinnerTeamID() {
        return this.winnerTeamID;
    }

    public void setWinnerTeamID(int winnerTeamID) {
        this.winnerTeamID = winnerTeamID;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int getMinuteExtra() {
        return this.minuteExtra;
    }

    public void setMinuteExtra(int minuteExtra) {
        this.minuteExtra = minuteExtra;
    }

    public boolean isFullCoverage() {
        return this.fullCoverage;
    }

    public void setFullCoverage(boolean fullCoverage) {
        this.fullCoverage = fullCoverage;
    }

    public int getMatches() {
        return this.matches;
    }

    public void setMatches(int matches) {
        this.matches = matches;
    }

    public List<RecordItem> getLstMatches() {
        return this.lstMatches;
    }

    public void setLstMatches(List<RecordItem> lstMatches) {
        this.lstMatches = lstMatches;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public SportStatisticsApi getPerson() {
        return this.person;
    }

    public void setPerson(SportStatisticsApi person) {
        this.person = person;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public int getAttendance() {
        return this.attendance;
    }

    public void setAttendance(int attendance) {
        this.attendance = attendance;
    }

    public int getCompetitionSeasonId() {
        return this.competitionSeasonId;
    }

    public void setCompetitionSeasonId(int competitionSeasonId) {
        this.competitionSeasonId = competitionSeasonId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getDisqusUrl() {
        return this.disqusUrl;
    }

    public void setDisqusUrl(String disqusUrl) {
        this.disqusUrl = disqusUrl;
    }

    public SportStatisticsApi getCompetition() {
        return this.competition;
    }

    public void setCompetition(SportStatisticsApi competition) {
        this.competition = competition;
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public void setVideos(List<Video> videos) {
        this.videos = videos;
    }

    public String toString() {
        return "RecordItem [id=" + this.id + ", roundId=" + this.roundId + ", roundName=" + this.roundName + ", dateTime=" + this.dateTime + ", dateTimeStamp=" + this.dateTimeStamp + ", homeTeam=" + this.homeTeam + ", homeTeamSlotName=" + this.homeTeamSlotName + ", homeTeamScore=" + this.homeTeamScore + ", homeTeamHalfTimeScore=" + this.homeTeamHalfTimeScore + ", awayTeam=" + this.awayTeam + ", awayTeamSlotName=" + this.awayTeamSlotName + ", awayTeamScore=" + this.awayTeamScore + ", awayTeamHalfTimeScore=" + this.awayTeamHalfTimeScore + ", venue=" + this.venue + ", status=" + this.status + ", period=" + this.period + ", aggregate=" + this.aggregate + ", channels=" + this.channels + ", winnerTeamID=" + this.winnerTeamID + ", minute=" + this.minute + ", minuteExtra=" + this.minuteExtra + ", fullCoverage=" + this.fullCoverage + ", goals=" + this.goals + ", round=" + this.round + ", matches=" + this.matches + ", lstMatches=" + this.lstMatches + ", position=" + this.position + ", rank=" + this.rank + ", person=" + this.person + ", team=" + this.team + ", attendance=" + this.attendance + ", competitionSeasonId=" + this.competitionSeasonId + ", name=" + this.name + ", fullName=" + this.fullName + ", disqusUrl=" + this.disqusUrl + ", competition=" + this.competition + ", videos=" + this.videos + "]";
    }
}

