/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.text.Normalizer;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Slug {
    private static final Pattern pattern;
    private static final HashSet<Character> allowed;

    static {
        char[] allowed_chars;
        pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        allowed = new HashSet();
        char[] cArray = allowed_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ--".toCharArray();
        int n = allowed_chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            allowed.add(Character.valueOf(c));
            ++n2;
        }
    }

    private static final String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static final String sane(String input) {
        char[] in_chars = input.toCharArray();
        StringBuilder result = new StringBuilder();
        int ix = in_chars.length;
        char[] cArray = in_chars;
        int n = in_chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            --ix;
            if (allowed.contains(Character.valueOf(c))) {
                result.append(c);
            } else if (ix > 0) {
                result.append('-');
            }
            ++n2;
        }
        return result.toString();
    }

    public static final String create(String title) {
        String stitle = StringUtils.lowerCase((String)StringUtils.replace((String)title, (String)".", (String)""));
        stitle = Slug.sane(Slug.deAccent(stitle));
        return stitle;
    }
}

