/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.sapodesporto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import pt.sapo.sapofe.api.sapodesporto.RecordItem;
import pt.sapo.sapofe.api.sapodesporto.RecordMetadata;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsApi;
import pt.sapo.sapofe.api.sapodesporto.TeamFormation;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SportStatisticsStructuredApi
implements Serializable {
    private static final long serialVersionUID = -5011786959834567316L;
    @JsonProperty(value="Structure")
    private List<SportStatisticsApi> structure;
    @JsonProperty(value="Active")
    private List<SportStatisticsApi> active;
    @JsonProperty(value="Records")
    private List<RecordItem> records;
    @JsonProperty(value="Metadata")
    private RecordMetadata metadata;
    @JsonProperty(value="HomeTeam")
    private TeamFormation homeTeam;
    @JsonProperty(value="AwayTeam")
    private TeamFormation awayTeam;
    private TeamFormation totalStats;
    @JsonProperty(value="Referees")
    private List<SportStatisticsApi> referees;
    @JsonProperty(value="TeamA")
    private TeamFormation teamA;
    @JsonProperty(value="TeamB")
    private TeamFormation teamB;

    public SportStatisticsStructuredApi() {
    }

    public SportStatisticsStructuredApi(String st) {
    }

    public List<SportStatisticsApi> getStructure() {
        return this.structure;
    }

    public void setStructure(List<SportStatisticsApi> structure) {
        this.structure = structure;
    }

    public List<SportStatisticsApi> getActive() {
        return this.active;
    }

    public void setActive(List<SportStatisticsApi> active) {
        this.active = active;
    }

    public List<RecordItem> getRecords() {
        return this.records;
    }

    public void setRecords(List<RecordItem> records) {
        this.records = records;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(RecordMetadata metadata) {
        this.metadata = metadata;
    }

    public TeamFormation getHomeTeam() {
        return this.homeTeam;
    }

    public void setHomeTeam(TeamFormation homeTeam) {
        this.homeTeam = homeTeam;
        this.parceTotalStats(homeTeam);
    }

    public TeamFormation getAwayTeam() {
        return this.awayTeam;
    }

    public void setAwayTeam(TeamFormation awayTeam) {
        this.awayTeam = awayTeam;
        this.parceTotalStats(awayTeam);
    }

    public List<SportStatisticsApi> getReferees() {
        return this.referees;
    }

    public TeamFormation getTotalStats() {
        return this.totalStats;
    }

    public void setTotalStats(TeamFormation totalStats) {
        this.totalStats = totalStats;
    }

    public void setReferees(List<SportStatisticsApi> referees) {
        this.referees = referees;
    }

    public TeamFormation getTeamA() {
        return this.teamA;
    }

    public void setTeamA(TeamFormation teamA) {
        this.teamA = teamA;
    }

    public TeamFormation getTeamB() {
        return this.teamB;
    }

    public void setTeamB(TeamFormation teamB) {
        this.teamB = teamB;
    }

    private void parceTotalStats(TeamFormation teamStats) {
        if (this.totalStats == null) {
            this.totalStats = new TeamFormation();
        }
        this.totalStats.setAttacks(this.totalStats.getAttacks() + teamStats.getAttacks());
        this.totalStats.setDangerousAttacks(this.totalStats.getDangerousAttacks() + teamStats.getDangerousAttacks());
        this.totalStats.setBallPossession(this.totalStats.getBallPossession() + teamStats.getBallPossession());
        this.totalStats.setOffsides(this.totalStats.getOffsides() + teamStats.getOffsides());
        this.totalStats.setSubstitutions(this.totalStats.getSubstitutions() + teamStats.getSubstitutions());
        this.totalStats.setCorners(this.totalStats.getCorners() + teamStats.getCorners());
        this.totalStats.setFreeKicks(this.totalStats.getFreeKicks() + teamStats.getFreeKicks());
        this.totalStats.setGoalKicks(this.totalStats.getGoalKicks() + teamStats.getGoalKicks());
        this.totalStats.setThrowIns(this.totalStats.getThrowIns() + teamStats.getThrowIns());
        this.totalStats.setDoubleYellowCards(this.totalStats.getDoubleYellowCards() + teamStats.getDoubleYellowCards());
        this.totalStats.setYellowCards(this.totalStats.getYellowCards() + teamStats.getYellowCards());
        this.totalStats.setRedCards(this.totalStats.getRedCards() + teamStats.getRedCards());
        this.totalStats.setFouls(this.totalStats.getFouls() + teamStats.getFouls());
        this.totalStats.setGoals(this.totalStats.getGoals() + teamStats.getGoals());
        this.totalStats.setOwnGoals(this.totalStats.getOwnGoals() + teamStats.getOwnGoals());
        this.totalStats.setPenaltyGoals(this.totalStats.getPenaltyGoals() + teamStats.getPenaltyGoals());
        this.totalStats.setShots(this.totalStats.getShots() + teamStats.getShots());
        this.totalStats.setShotsOnGoal(this.totalStats.getShotsOnGoal() + teamStats.getShotsOnGoal());
        this.totalStats.setShotsWide(this.totalStats.getShotsWide() + teamStats.getShotsWide());
        this.totalStats.setShotsWoodwork(this.totalStats.getShotsWoodwork() + teamStats.getShotsWoodwork());
        this.totalStats.setShotsBlocked(this.totalStats.getShotsBlocked() + teamStats.getShotsBlocked());
    }

    public String toString() {
        return "SportStatisticsStructuredApi [structure=" + this.structure + ", active=" + this.active + ", records=" + this.records + ", metadata=" + this.metadata + ", homeTeam=" + this.homeTeam + ", awayTeam=" + this.awayTeam + ", totalStats=" + this.totalStats + ", referees=" + this.referees + ", teamA=" + this.teamA + ", teamB=" + this.teamB + "]";
    }
}

