/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.net.InetAddress;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Constants {
    private static final Logger log = LoggerFactory.getLogger(Constants.class);
    public static final String[] STATIC_ASSETS_EXTENSIONS = new String[]{"ico", "txt", "xml", "html", "htm", "css", "js", "jpg", "jpeg", "gif", "png", "svg"};
    public static final Properties properties = new Properties();
    public static final Map<Integer, String> monthsSimple = new LinkedHashMap<Integer, String>();
    public static final Map<Integer, String> monthsFullName = new LinkedHashMap<Integer, String>();
    public static String X_SERVER;

    static {
        monthsSimple.put(1, "jan");
        monthsSimple.put(2, "fev");
        monthsSimple.put(3, "mar");
        monthsSimple.put(4, "abr");
        monthsSimple.put(5, "mai");
        monthsSimple.put(6, "jun");
        monthsSimple.put(7, "jul");
        monthsSimple.put(8, "ago");
        monthsSimple.put(9, "set");
        monthsSimple.put(10, "out");
        monthsSimple.put(11, "nov");
        monthsSimple.put(12, "dez");
        monthsFullName.put(1, "Janeiro");
        monthsFullName.put(2, "Fevereiro");
        monthsFullName.put(3, "Mar\u00e7o");
        monthsFullName.put(4, "Abril");
        monthsFullName.put(5, "Maio");
        monthsFullName.put(6, "Junho");
        monthsFullName.put(7, "Julho");
        monthsFullName.put(8, "Agosto");
        monthsFullName.put(9, "Setembro");
        monthsFullName.put(10, "Outubro");
        monthsFullName.put(11, "Novembro");
        monthsFullName.put(12, "Dezembro");
        String projectName = System.getProperty("project", null);
        String environment = System.getProperty("environment", "staging");
        System.out.println("CONSTANS: project name " + projectName);
        System.out.println("CONSTANS: loading settings for " + environment);
        try {
            String[] requiredProperties;
            switch (InetAddress.getLocalHost().getHostName()) {
                case "sapo-hp01.hp.bk.sapo.pt": {
                    X_SERVER = "Kalahari";
                    break;
                }
                case "sapo-hp02.hp.bk.sapo.pt": {
                    X_SERVER = "Kara Kum";
                    break;
                }
                case "sapo-hp03.hp.bk.sapo.pt": {
                    X_SERVER = "Bardenas Reales";
                    break;
                }
                case "sapo-hp04.hp.bk.sapo.pt": {
                    X_SERVER = "Mojave";
                    break;
                }
                case "sapo-hp05.hp.bk.sapo.pt": {
                    X_SERVER = "Atacama";
                    break;
                }
                default: {
                    X_SERVER = "Sahara";
                }
            }
            ResourceBundle resBundle = ResourceBundle.getBundle(environment);
            if (projectName != null) {
                resBundle = ResourceBundle.getBundle(String.valueOf(projectName) + "-" + environment);
            }
            Enumeration<String> keys = resBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                properties.put(key, resBundle.getString(key));
                log.debug("CONSTANS: got: '{}' = '{}' ", (Object)key, (Object)resBundle.getString(key));
            }
            String[] stringArray = requiredProperties = new String[0];
            int n = requiredProperties.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProperty = stringArray[n2];
                if (properties.get(requiredProperty) == null) {
                    throw new IllegalArgumentException(String.format("missing property: %s", requiredProperty));
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static Map<Integer, String> getMonthsSimple() {
        return monthsSimple;
    }

    public static Map<Integer, String> getMonthsFullName() {
        return monthsFullName;
    }
}

