/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Url {
    private static Logger log = LoggerFactory.getLogger(Url.class);

    public static final String encUri(String s) {
        try {
            char[] chars = s.toCharArray();
            StringBuilder sb = new StringBuilder();
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Url.isAsciiPrintable(c)) {
                    sb.append(c);
                } else {
                    char[] sp = new char[]{c};
                    sb.append(URLEncoder.encode(new String(sp), "utf8"));
                }
                ++n2;
            }
            return URLEncoder.encode(sb.toString(), "utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String enc(String s) {
        try {
            char[] chars = s.toCharArray();
            StringBuilder sb = new StringBuilder();
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Url.isAsciiPrintable(c)) {
                    sb.append(c);
                } else {
                    char[] sp = new char[]{c};
                    sb.append(URLEncoder.encode(new String(sp), "utf-8"));
                }
                ++n2;
            }
            return URLEncoder.encode(sb.toString(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeURIComponent(String s) {
        String result;
        try {
            result = StringUtils.replaceEach((String)URLEncoder.encode(s, "UTF8"), (String[])new String[]{"+", "%21", "%27", "%28", "%29", "%7E"}, (String[])new String[]{"%20", "!", "'", "(", ")", "~"});
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    private static final boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static final String dec(String s) {
        try {
            return URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String dec(String[] param_parts) {
        try {
            if (param_parts.length >= 2) {
                return URLDecoder.decode(param_parts[1], "utf-8");
            }
            return "";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String[] getUrlParameters(String url) {
        return StringUtils.split((String)StringUtils.substringAfter((String)url, (String)"?"), (char)'&');
    }

    public static final String sanitizeQSParameters(String sphoto, String ... validParameters) {
        try {
            String qs = StringUtils.substringAfter((String)sphoto, (String)"?");
            if (StringUtils.isBlank((CharSequence)qs)) {
                return sphoto;
            }
            String url = StringUtils.substringBefore((String)sphoto, (String)"?");
            String[] params = StringUtils.split((String)qs, (char)'&');
            StringBuilder sb_url = new StringBuilder(url);
            sb_url.append('?');
            List<String> lstValidParams = Arrays.asList(validParameters);
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] param_parts = StringUtils.split((String)param, (char)'=');
                String param_name = param_parts[0];
                String param_value = null;
                if (param_parts.length == 2) {
                    param_value = param_parts[1];
                }
                if (lstValidParams.contains(param_name)) {
                    sb_url.append(param_name);
                    if (param_parts.length == 2) {
                        sb_url.append('=');
                        sb_url.append(param_value);
                    }
                    sb_url.append('&');
                }
                ++n2;
            }
            return StringUtils.removeEnd((String)sb_url.toString(), (String)"&");
        }
        catch (Throwable t) {
            log.error("sphoto: {} -> {} ", (Object)sphoto, (Object)t.toString());
            t.printStackTrace();
            return sphoto;
        }
    }

    public static final String makeSlug(String input) {
        Pattern NONLATIN = Pattern.compile("[^\\w-]");
        Pattern WHITESPACE = Pattern.compile("[\\s]");
        String nowhitespace = WHITESPACE.matcher(input).replaceAll("-");
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        String slug = NONLATIN.matcher(normalized).replaceAll("");
        return slug.toLowerCase(Locale.ENGLISH);
    }

    public static final String getGenerateDestinationUrl(String name, String locationId) {
        return String.format("/viajar/destinos/%s-d%s", Url.makeSlug(StringUtils.lowerCase((String)name)), locationId);
    }
}

