/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools.promos;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.promos.PromosApi;
import pt.sapo.sapofe.tools.promos.JsonPromosResponseHandler;
import pt.sapo.sapofe.tools.sapodesporto.SportHttpClient;

public class PromosHttpClient {
    private static Logger log = LoggerFactory.getLogger(SportHttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonPromosResponseHandler rsp_promos_handler = new JsonPromosResponseHandler();

    private PromosApi doHttpRequestPromos(HttpRequestBase httpget, JsonPromosResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (PromosApi)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_promos_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to PromosApi - %s%n", r.getMessage()));
            return null;
        }
    }

    public PromosApi doGetPromos(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestPromos((HttpRequestBase)httpget, this.rsp_promos_handler);
    }

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(10000).setConnectTimeout(5000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

