/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pt.sapo.sapofe.api.Attribute;
import pt.sapo.sapofe.api.Block;
import pt.sapo.sapofe.api.BoxOffice;
import pt.sapo.sapofe.api.BoxOfficeItem;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.Columns;
import pt.sapo.sapofe.api.EpgChannel;
import pt.sapo.sapofe.api.Image;
import pt.sapo.sapofe.api.Metadata;
import pt.sapo.sapofe.api.Newspaper;
import pt.sapo.sapofe.api.VideoClub;
import pt.sapo.sapofe.api.lifestyle.Entrie;
import pt.sapo.sapofe.api.lifestyle.EntrieList;
import pt.sapo.sapofe.api.sapoauto.Vehicle;
import pt.sapo.sapofe.api.sapoauto.VehicleSimple;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsApi;
import pt.sapo.sapofe.api.sapoexperience.Campaign;
import pt.sapo.sapofe.api.sapovideos.Video;
import pt.sapo.sapofe.api.shopk.ProductShopkAPI;
import pt.sapo.sapofe.api.social.InstagramMedia;
import pt.sapo.sapofe.tools.JsonConverter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Attributes
implements Serializable {
    private static final long serialVersionUID = -2552078452872360811L;
    private String title;
    private Attributes content;
    private String contentValue;
    @JsonProperty(value="content_type")
    private String contentType;
    private String contentTitle;
    private String contentLink;
    @JsonProperty(value="block_title")
    private String blockTitle;
    @JsonProperty(value="title_align")
    private String titleAlign;
    @JsonProperty(value="placeholder_type")
    private String placeholderType;
    @JsonProperty(value="highlights_group")
    private String highlightsGroup;
    private List<String> categories;
    @JsonProperty(value="num_items")
    private int numItems;
    @JsonProperty(value="img_ratio")
    private String imgRatio;
    @JsonProperty(value="css_class")
    private String cssClass;
    private String badge;
    @JsonProperty(value="post_type")
    private String postType;
    private String text;
    @JsonProperty(value="link_to")
    private String linkTo;
    private String link;
    @JsonProperty(value="link_text")
    private String linkText;
    @JsonProperty(value="link_title")
    private String linkTitle;
    private boolean externalLink = false;
    @JsonProperty(value="rich_text")
    private String richText;
    @JsonProperty(value="link_author")
    private String linkAuthor;
    private String author;
    @JsonProperty(value="author_object")
    private Attributes authorObject;
    private String tag;
    private String partner;
    private String blogger;
    @JsonProperty(value="sponsored_content")
    private boolean sponsoredContent = false;
    @JsonProperty(value="display_format")
    private String displayFormat;
    private String layout;
    private Image image;
    private String category;
    private List<String> columns;
    @JsonProperty(value="sapovideos_randname")
    private String sapoVideosRandname;
    @JsonProperty(value="sapovideos_user")
    private String sapoVideosUser;
    @JsonProperty(value="postcard_user")
    private String postcardUser;
    @JsonProperty(value="postcard_user_img")
    private Image postcardUserImg;
    private String gender;
    private List<Campaign> fullExperienceCampaigns;
    private List<ProductShopkAPI> shopkProductList;
    private List<Vehicle> listVehicle;
    private List<VehicleSimple> vehicles;
    @JsonProperty(value="special_id")
    private String specialId;
    private CanaisAPI fullSpecial;
    private List<CanaisAPI> highlights;
    private List<Newspaper> newspapers;
    private List<Video> videos;
    @JsonProperty(value="sponsor")
    private String sponsorId;
    private CanaisAPI FullSponsor;
    @JsonProperty(value="newspapers_list")
    private List<Attribute> newspapersList;
    @JsonProperty(value="show_menu")
    private boolean showMenu;
    private boolean showTodayBlock;
    private List<Entrie> entries;
    private List<CanaisAPI> items;
    private List<CanaisAPI> bloggers;
    private List<CanaisAPI> galleries;
    private EntrieList birth;
    private EntrieList pregnancy;
    @JsonProperty(value="raw_html")
    private String rawHtml;
    @JsonProperty(value="sapo_fun_id")
    private String sapoFunId;
    @JsonProperty(value="today_guide")
    private List<EpgChannel> todayGuide;
    private List<VideoClub> movies;
    @JsonProperty(value="top_box_office")
    private BoxOffice topBoxOffice;
    private CanaisAPI article;
    private List<Attribute> links;
    private String edition;
    private List<Columns> columnsObject;
    private List<SportStatisticsApi> rankingsTable;
    private Map<String, List<CanaisAPI>> highlightsCategory;
    private List<Attribute> related;
    private List<InstagramMedia> instagramFeed;
    private Attribute main;
    private Attribute first;
    private Attribute second;
    private Attribute third;
    private Attribute fourth;
    private Attribute fifth;
    private Attribute sixth;
    private List<Block> elements;
    @JsonProperty(value="video_posts")
    private List<CanaisAPI> videoPosts;
    private List<CanaisAPI> events;
    private ArrayList<Attribute> lstRet;

    @JsonProperty(value="main")
    public void setMain(Attribute main) {
        this.main = main;
    }

    @JsonProperty(value="first")
    public void setFirst(Attribute first) {
        this.setAttrib(first, "first");
        this.first = first;
    }

    @JsonProperty(value="second")
    public void setSecond(Attribute second) {
        this.setAttrib(second, "second");
        this.second = second;
    }

    @JsonProperty(value="third")
    public void setThird(Attribute third) {
        this.setAttrib(third, "third");
        this.third = third;
    }

    @JsonProperty(value="fourth")
    public void setFourth(Attribute fourth) {
        this.setAttrib(fourth, "fourth");
        this.fourth = fourth;
    }

    @JsonProperty(value="fifth")
    public void setFifth(Attribute fifth) {
        this.setAttrib(fifth, "fifth");
        this.fifth = fifth;
    }

    @JsonProperty(value="sixth")
    public void setSixth(Attribute sixth) {
        this.setAttrib(sixth, "sixth");
        this.sixth = sixth;
    }

    public void setAttrib(Attribute attr, String name) {
        if (this.lstRet == null) {
            this.lstRet = new ArrayList();
        }
        if (attr != null && !StringUtils.isEmpty((CharSequence)attr.getChannel())) {
            attr.setCategory(attr.getChannel());
        }
        if (attr != null && !StringUtils.isEmpty((CharSequence)attr.getScheduleDate())) {
            attr.setCategory(attr.getCategory() + " \u00b7 " + attr.getScheduleDate());
        }
        if (attr != null && !StringUtils.isEmpty((CharSequence)attr.getSchedule())) {
            attr.setCategory(attr.getCategory() + " \u00b7 " + attr.getSchedule());
        }
        attr.set_name(name);
        this.lstRet.add(attr);
    }

    @JsonSetter(value="items")
    public void setEntrieOrItems(JsonNode jsonNode) {
        if (jsonNode != null && jsonNode.isArray()) {
            ArrayList<Entrie> lstEntrie = new ArrayList<Entrie>();
            ArrayList<CanaisAPI> lstItems = new ArrayList<CanaisAPI>();
            for (JsonNode jsonElmNode : jsonNode) {
                JsonConverter<CanaisAPI> mapperCanaisApi = new JsonConverter<CanaisAPI>(CanaisAPI.class);
                try {
                    lstItems.add(mapperCanaisApi.convertValue(jsonElmNode));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JsonConverter<Entrie> mapperEntrie = new JsonConverter<Entrie>(Entrie.class);
                try {
                    lstEntrie.add(mapperEntrie.convertValue(jsonElmNode));
                }
                catch (Exception exception) {}
            }
            this.entries = lstEntrie;
            this.items = lstItems;
        }
    }

    @JsonSetter(value="related")
    public void setRelatedInternal(JsonNode relatedInternal) {
        ArrayList<Attribute> _lstAttribute = new ArrayList<Attribute>();
        ObjectMapper mapper = new ObjectMapper();
        if (relatedInternal != null && relatedInternal.isArray()) {
            for (JsonNode relatedElmInternal : relatedInternal) {
                if (relatedElmInternal.isArray()) continue;
                _lstAttribute.add((Attribute)mapper.convertValue((Object)relatedElmInternal, Attribute.class));
            }
        }
        this.related = _lstAttribute;
    }

    @JsonSetter(value="columns")
    public void setColumnsInternal(JsonNode jsonNode) {
        ArrayList<String> lstString = new ArrayList<String>();
        ArrayList<Columns> lstColumns = new ArrayList<Columns>();
        if (jsonNode != null && jsonNode.isArray()) {
            for (JsonNode jsonElmNode : jsonNode) {
                if (jsonElmNode.isTextual()) {
                    lstString.add(jsonElmNode.asText());
                } else if (jsonElmNode.isObject()) {
                    JsonConverter<Columns> mapper = new JsonConverter<Columns>(Columns.class);
                    lstColumns.add(mapper.convertValue(jsonElmNode));
                }
                this.columns = lstString;
                this.columnsObject = lstColumns;
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.blockTitle = title;
    }

    public String getBlockTitle() {
        return this.blockTitle;
    }

    public void setBlockTitle(String blockTitle) {
        this.blockTitle = blockTitle;
    }

    public String getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(String titleAlign) {
        this.titleAlign = titleAlign;
    }

    public String getPlaceholderType() {
        return this.placeholderType;
    }

    public void setPlaceholderType(String placeholderType) {
        this.placeholderType = placeholderType;
    }

    public String getHighlightsGroup() {
        return this.highlightsGroup;
    }

    public void setHighlightsGroup(String highlightsGroup) {
        this.highlightsGroup = highlightsGroup;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public int getNumItems() {
        return this.numItems;
    }

    public void setNumItems(int numItems) {
        this.numItems = numItems;
    }

    public String getImgRatio() {
        return this.imgRatio;
    }

    public void setImgRatio(String imgRatio) {
        this.imgRatio = imgRatio;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public String getBadge() {
        return this.badge;
    }

    public void setBadge(String badge) {
        this.badge = badge;
    }

    public String getPostType() {
        return this.postType;
    }

    public void setPostType(String postType) {
        this.postType = postType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLinkTo() {
        return this.linkTo;
    }

    public void setLinkTo(String linkTo) {
        this.linkTo = linkTo;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        if (link.startsWith("http")) {
            this.externalLink = true;
        }
        this.linkTo = link;
        this.link = link;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public void setLinkText(String linkText) {
        this.linkText = linkText;
        this.linkTitle = linkText;
    }

    public String getLinkTitle() {
        return this.linkTitle;
    }

    public void setLinkTitle(String linkTitle) {
        this.linkTitle = linkTitle;
    }

    public boolean isExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(boolean externalLink) {
        this.externalLink = externalLink;
    }

    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String richText) {
        this.richText = richText;
    }

    public String getLinkAuthor() {
        return this.linkAuthor;
    }

    public void setLinkAuthor(String linkAuthor) {
        this.linkAuthor = linkAuthor;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Attributes getAuthorObject() {
        return this.authorObject;
    }

    public void setAuthorObject(Attributes authorObject) {
        this.authorObject = authorObject;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getPartner() {
        return this.partner;
    }

    public void setPartner(String partner) {
        if (!StringUtils.isEmpty((CharSequence)partner)) {
            this.category = partner;
        }
        this.partner = partner;
    }

    public String getBlogger() {
        return this.blogger;
    }

    public void setBlogger(String blogger) {
        this.blogger = blogger;
        this.partner = blogger;
    }

    public boolean isSponsoredContent() {
        return this.sponsoredContent;
    }

    public void setSponsoredContent(boolean sponsoredContent) {
        this.sponsoredContent = sponsoredContent;
    }

    public String getDisplayFormat() {
        return this.displayFormat;
    }

    public void setDisplayFormat(String displayFormat) {
        this.displayFormat = displayFormat;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSapoVideosRandname() {
        return this.sapoVideosRandname;
    }

    public void setSapoVideosRandname(String sapoVideosRandname) {
        this.sapoVideosRandname = sapoVideosRandname;
    }

    public String getSapoVideosUser() {
        return this.sapoVideosUser;
    }

    public void setSapoVideosUser(String sapoVideosUser) {
        this.sapoVideosUser = sapoVideosUser;
    }

    public String getPostcardUser() {
        return this.postcardUser;
    }

    public Image getPostcardUserImg() {
        return this.postcardUserImg;
    }

    public String getGender() {
        return this.gender;
    }

    public void setPostcardUser(String postcardUser) {
        this.postcardUser = postcardUser;
    }

    public void setPostcardUserImg(Image postcardUserImg) {
        this.postcardUserImg = postcardUserImg;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public List<Campaign> getFullExperienceCampaigns() {
        return this.fullExperienceCampaigns;
    }

    public void setFullExperienceCampaigns(List<Campaign> fullExperienceCampaigns) {
        this.fullExperienceCampaigns = fullExperienceCampaigns;
    }

    public List<ProductShopkAPI> getShopkProductList() {
        return this.shopkProductList;
    }

    public void setShopkProductList(List<ProductShopkAPI> shopkProductList) {
        this.shopkProductList = shopkProductList;
    }

    public List<Vehicle> getListVehicle() {
        return this.listVehicle;
    }

    public void setListVehicle(List<Vehicle> listVehicle) {
        this.listVehicle = listVehicle;
    }

    public List<VehicleSimple> getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(List<VehicleSimple> vehicles) {
        this.vehicles = vehicles;
    }

    public String getSpecialId() {
        return this.specialId;
    }

    public void setSpecialId(String specialId) {
        this.specialId = specialId;
    }

    public CanaisAPI getFullSpecial() {
        return this.fullSpecial;
    }

    public void setFullSpecial(CanaisAPI fullSpecial) {
        this.fullSpecial = fullSpecial;
    }

    public List<CanaisAPI> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(List<CanaisAPI> highlights) {
        this.highlights = highlights;
    }

    public List<Newspaper> getNewspapers() {
        return this.newspapers;
    }

    public void setNewspapers(List<Newspaper> newspapers) {
        this.newspapers = newspapers;
    }

    public List<Video> getVideos() {
        return this.videos;
    }

    public void setVideos(List<Video> videos) {
        this.videos = videos;
    }

    public String getSponsorId() {
        return this.sponsorId;
    }

    public void setSponsorId(String sponsorId) {
        this.sponsorId = sponsorId;
    }

    public CanaisAPI getFullSponsor() {
        return this.FullSponsor;
    }

    public void setFullSponsor(CanaisAPI fullSponsor) {
        this.FullSponsor = fullSponsor;
    }

    public List<Attribute> getNewspapersList() {
        return this.newspapersList;
    }

    public void setNewspapersList(List<Attribute> newspapersList) {
        this.newspapersList = newspapersList;
    }

    public boolean isShowMenu() {
        return this.showMenu;
    }

    public void setShowMenu(boolean showMenu) {
        this.showMenu = showMenu;
    }

    public boolean isShowTodayBlock() {
        return this.showTodayBlock;
    }

    public void setShowTodayBlock(boolean showTodayBlock) {
        this.showTodayBlock = showTodayBlock;
    }

    public List<Entrie> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entrie> entries) {
        this.entries = entries;
    }

    public List<CanaisAPI> getBloggers() {
        return this.bloggers;
    }

    public void setBloggers(List<CanaisAPI> bloggers) {
        this.bloggers = bloggers;
    }

    public List<CanaisAPI> getGalleries() {
        return this.galleries;
    }

    public void setGalleries(List<CanaisAPI> galleries) {
        if (galleries != null && galleries.size() > 0) {
            for (CanaisAPI gallerie : galleries) {
                Metadata metadata = gallerie.getMetadata();
                if (metadata == null) {
                    metadata = new Metadata();
                }
                gallerie.getMetadata().setPhotoGalleryId(gallerie.getId());
            }
        }
        this.galleries = galleries;
    }

    public List<CanaisAPI> getItems() {
        return this.items;
    }

    public void setItems(List<CanaisAPI> items) {
        this.items = items;
    }

    public Map<String, List<CanaisAPI>> getHighlightsCategory() {
        return this.highlightsCategory;
    }

    public void setHighlightsCategory(Map<String, List<CanaisAPI>> highlightsCategory) {
        this.highlightsCategory = highlightsCategory;
    }

    public List<Attribute> getRelated() {
        return this.related;
    }

    public void setRelated(List<Attribute> related) {
        this.related = related;
    }

    public List<InstagramMedia> getInstagramFeed() {
        return this.instagramFeed;
    }

    public void setInstagramFeed(List<InstagramMedia> instagramFeed) {
        this.instagramFeed = instagramFeed;
    }

    public ArrayList<Attribute> getLstRet() {
        return this.lstRet;
    }

    public void setLstRet(ArrayList<Attribute> lstRet) {
        this.lstRet = lstRet;
    }

    public String getRawHtml() {
        return this.rawHtml;
    }

    public void setRawHtml(String rawHtml) {
        this.rawHtml = rawHtml;
    }

    public String getSapoFunId() {
        return this.sapoFunId;
    }

    public void setSapoFunId(String sapoFunId) {
        this.sapoFunId = sapoFunId;
    }

    public List<EpgChannel> getTodayGuide() {
        return this.todayGuide;
    }

    public void setTodayGuide(List<EpgChannel> todayGuide) {
        this.todayGuide = todayGuide;
    }

    public List<VideoClub> getMovies() {
        return this.movies;
    }

    public void setMovies(List<VideoClub> movies) {
        this.movies = movies;
    }

    public BoxOffice getTopBoxOffice() {
        return this.topBoxOffice;
    }

    public void setTopBoxOffice(BoxOffice topBoxOffice) {
        ArrayList<BoxOfficeItem> _lstBoxOfficeItem;
        if (topBoxOffice != null && topBoxOffice.getPt() != null) {
            _lstBoxOfficeItem = new ArrayList<BoxOfficeItem>();
            for (Map.Entry<String, BoxOfficeItem> item : topBoxOffice.getPt().entrySet()) {
                _lstBoxOfficeItem.add(item.getValue());
            }
            Collections.sort(_lstBoxOfficeItem, new Comparator<BoxOfficeItem>(){

                @Override
                public int compare(BoxOfficeItem value2, BoxOfficeItem value3) {
                    return value2.getValueInteger().compareTo(value2.getValueInteger());
                }
            });
            topBoxOffice.setPtBoxOffice(_lstBoxOfficeItem);
        }
        if (topBoxOffice != null && topBoxOffice.getUs() != null) {
            _lstBoxOfficeItem = new ArrayList();
            for (Map.Entry<String, BoxOfficeItem> item : topBoxOffice.getUs().entrySet()) {
                _lstBoxOfficeItem.add(item.getValue());
            }
            Collections.sort(_lstBoxOfficeItem, new Comparator<BoxOfficeItem>(){

                @Override
                public int compare(BoxOfficeItem value2, BoxOfficeItem value3) {
                    return value2.getValueInteger().compareTo(value2.getValueInteger());
                }
            });
            topBoxOffice.setUsBoxOffice(_lstBoxOfficeItem);
        }
        this.topBoxOffice = topBoxOffice;
    }

    public CanaisAPI getArticle() {
        return this.article;
    }

    public void setArticle(CanaisAPI article) {
        this.article = article;
    }

    public List<Attribute> getLinks() {
        return this.links;
    }

    public void setLinks(List<Attribute> links) {
        this.links = links;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public List<Columns> getColumnsObject() {
        return this.columnsObject;
    }

    public void setColumnsObject(List<Columns> columnsObject) {
        this.columnsObject = columnsObject;
    }

    public List<SportStatisticsApi> getRankingsTable() {
        return this.rankingsTable;
    }

    public void setRankingsTable(List<SportStatisticsApi> rankingsTable) {
        this.rankingsTable = rankingsTable;
    }

    public Attribute getMain() {
        return this.main;
    }

    public Attribute getFirst() {
        return this.first;
    }

    public Attribute getSecond() {
        return this.second;
    }

    public Attribute getThird() {
        return this.third;
    }

    public Attribute getFourth() {
        return this.fourth;
    }

    public Attribute getFifth() {
        return this.fifth;
    }

    public Attribute getSixth() {
        return this.sixth;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Block> getElements() {
        return this.elements;
    }

    public void setElements(List<Block> elements) {
        if (!elements.isEmpty()) {
            ArrayList<Attribute> lstCombine = new ArrayList<Attribute>();
            for (Block elementBlock : elements) {
                if (elementBlock.getAttributes() == null) continue;
                lstCombine.addAll(elementBlock.getAttributes().getLstRet());
            }
            this.lstRet = lstCombine;
        }
        this.elements = elements;
    }

    public List<CanaisAPI> getVideoPosts() {
        return this.videoPosts;
    }

    public void setVideoPosts(List<CanaisAPI> videoPosts) {
        this.videoPosts = videoPosts;
    }

    public List<CanaisAPI> getEvents() {
        return this.events;
    }

    public void setEvents(List<CanaisAPI> events) {
        this.events = events;
    }

    public EntrieList getBirth() {
        return this.birth;
    }

    public void setBirth(EntrieList birth) {
        this.birth = birth;
    }

    public EntrieList getPregnancy() {
        return this.pregnancy;
    }

    public void setPregnancy(EntrieList pregnancy) {
        this.pregnancy = pregnancy;
    }

    public Attributes getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    public void setContent(JsonNode jsonNode) {
        if (jsonNode != null) {
            if (jsonNode.isTextual()) {
                this.contentValue = jsonNode.asText();
            } else {
                JsonConverter<Attributes> mapper = new JsonConverter<Attributes>(Attributes.class);
                this.content = mapper.convertValue(jsonNode);
            }
        }
    }

    public String getContentValue() {
        return this.contentValue;
    }

    public void setContentValue(String contentValue) {
        this.contentValue = contentValue;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentTitle() {
        return this.contentTitle;
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }

    public String getContentLink() {
        return this.contentLink;
    }

    public void setContentLink(String contentLink) {
        this.contentLink = contentLink;
    }

    public String toString() {
        return "Attributes [title=" + this.title + ", content=" + this.content + ", contentValue=" + this.contentValue + ", contentType=" + this.contentType + ", contentTitle=" + this.contentTitle + ", contentLink=" + this.contentLink + ", blockTitle=" + this.blockTitle + ", titleAlign=" + this.titleAlign + ", placeholderType=" + this.placeholderType + ", highlightsGroup=" + this.highlightsGroup + ", categories=" + this.categories + ", numItems=" + this.numItems + ", imgRatio=" + this.imgRatio + ", cssClass=" + this.cssClass + ", badge=" + this.badge + ", postType=" + this.postType + ", text=" + this.text + ", linkTo=" + this.linkTo + ", link=" + this.link + ", linkText=" + this.linkText + ", linkTitle=" + this.linkTitle + ", externalLink=" + this.externalLink + ", richText=" + this.richText + ", linkAuthor=" + this.linkAuthor + ", author=" + this.author + ", authorObject=" + this.authorObject + ", tag=" + this.tag + ", partner=" + this.partner + ", blogger=" + this.blogger + ", sponsoredContent=" + this.sponsoredContent + ", displayFormat=" + this.displayFormat + ", layout=" + this.layout + ", image=" + this.image + ", category=" + this.category + ", columns=" + this.columns + ", sapoVideosRandname=" + this.sapoVideosRandname + ", sapoVideosUser=" + this.sapoVideosUser + ", postcardUser=" + this.postcardUser + ", postcardUserImg=" + this.postcardUserImg + ", gender=" + this.gender + ", fullExperienceCampaigns=" + this.fullExperienceCampaigns + ", shopkProductList=" + this.shopkProductList + ", listVehicle=" + this.listVehicle + ", vehicles=" + this.vehicles + ", specialId=" + this.specialId + ", fullSpecial=" + this.fullSpecial + ", highlights=" + this.highlights + ", newspapers=" + this.newspapers + ", videos=" + this.videos + ", sponsorId=" + this.sponsorId + ", FullSponsor=" + this.FullSponsor + ", newspapersList=" + this.newspapersList + ", showMenu=" + this.showMenu + ", showTodayBlock=" + this.showTodayBlock + ", entries=" + this.entries + ", items=" + this.items + ", bloggers=" + this.bloggers + ", galleries=" + this.galleries + ", birth=" + this.birth + ", pregnancy=" + this.pregnancy + ", rawHtml=" + this.rawHtml + ", sapoFunId=" + this.sapoFunId + ", todayGuide=" + this.todayGuide + ", movies=" + this.movies + ", topBoxOffice=" + this.topBoxOffice + ", article=" + this.article + ", links=" + this.links + ", edition=" + this.edition + ", columnsObject=" + this.columnsObject + ", rankingsTable=" + this.rankingsTable + ", highlightsCategory=" + this.highlightsCategory + ", related=" + this.related + ", instagramFeed=" + this.instagramFeed + ", main=" + this.main + ", first=" + this.first + ", second=" + this.second + ", third=" + this.third + ", fourth=" + this.fourth + ", fifth=" + this.fifth + ", sixth=" + this.sixth + ", elements=" + this.elements + ", videoPosts=" + this.videoPosts + ", events=" + this.events + ", lstRet=" + this.lstRet + "]";
    }
}

