/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.Block;
import pt.sapo.sapofe.api.Categories;
import pt.sapo.sapofe.api.Embed;
import pt.sapo.sapofe.api.Embeds;
import pt.sapo.sapofe.api.Image;
import pt.sapo.sapofe.api.Metadata;
import pt.sapo.sapofe.api.Multimedia;
import pt.sapo.sapofe.api.Tag;
import pt.sapo.sapofe.api.Taxonomies;
import pt.sapo.sapofe.tools.JsonConverter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CanaisAPI
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CanaisAPI.class);
    private static final long serialVersionUID = 2421739680001298020L;
    private String id;
    private String name;
    private String description;
    private String type;
    private String slug;
    private String title;
    private String url;
    private Image thumb;
    private String status;
    @JsonProperty(value="author_id")
    private String authorId;
    private String excerpt;
    private String content;
    private List<String> pages;
    private int totalPages;
    @JsonProperty(value="publish_date")
    private String publishDate;
    @JsonProperty(value="update_date")
    private String updateDate;
    private List<Block> blocks;
    private Metadata metadata;
    private List<Categories> categories;
    private List<Embeds> embeds;
    private List<Tag> tags;
    private Taxonomies taxonomies;
    private Multimedia multimedia;
    private boolean externalLink;

    public CanaisAPI() {
    }

    public CanaisAPI(String st) {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals("photo_gallery")) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setPhotoGallery(true);
        }
        if (type.equals("recipe")) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setRecipe(true);
        }
        this.type = type;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        title = StringUtils.replace((String)title, (String)"Sapo24", (String)"SAPO 24");
        title = StringUtils.replace((String)title, (String)"sapo24", (String)"SAPO 24");
        this.title = title = StringUtils.replace((String)title, (String)"SAPO24", (String)"SAPO 24");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url != null && url.startsWith("/cinema/salas/")) {
            url = url.replace("/cinema/salas/", "/cinema/em-cartaz/sala/");
        }
        this.url = url;
    }

    public void setThumbnail(List<Image> thumbnail) {
        if (thumbnail != null && thumbnail.size() > 0) {
            this.thumb = thumbnail.get(0);
        }
    }

    public Image getThumb() {
        return this.thumb;
    }

    @JsonProperty(value="thumbnail")
    public void setThumb(Image thumb) {
        this.thumb = thumb;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public void setExcerpt(String excerpt) {
        excerpt = StringUtils.replace((String)excerpt, (String)"Sapo24", (String)"SAPO 24");
        excerpt = StringUtils.replace((String)excerpt, (String)"sapo24", (String)"SAPO 24");
        this.excerpt = excerpt = StringUtils.replace((String)excerpt, (String)"SAPO24", (String)"SAPO 24");
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public void setPages(List<String> pages) {
        this.totalPages = pages.size();
        this.pages = pages;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public String getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        if (!StringUtils.isEmpty((CharSequence)metadata.getPhotoGalleryId())) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setHasPhotoGallery(true);
            if (!StringUtils.isEmpty((CharSequence)metadata.getArticleType()) && metadata.getArticleType().equals("PHOTOGALLERY")) {
                this.multimedia.setPhotoGallery(true);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getVideoGalleryId())) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setHasVideoGallery(true);
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getArticleType())) {
            if (metadata.getArticleType().equals("LIVE_BLOG")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasLiveBlog(true);
            }
            if (metadata.getArticleType().equals("LONGFORM")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasLongform(true);
            }
            if (metadata.getArticleType().equals("VIDEO")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setVideo(true);
            }
        }
        if (metadata.getBlockpageBackgroundImage() != null) {
            this.setThumb(metadata.getBlockpageBackgroundImage());
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getSponsorName())) {
            this.title = metadata.getSponsorName();
        }
        this.metadata = metadata;
    }

    public List<Categories> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Categories> categories) {
        this.categories = categories;
    }

    public List<Embeds> getEmbeds() {
        return this.embeds;
    }

    @JsonProperty(value="embeds")
    public void setUnparsedEmbeds(List<Object> embeds) {
        ArrayList<Embeds> listEmbeds = new ArrayList<Embeds>();
        if (embeds.size() > 0) {
            Embeds parsedEmbeds = new Embeds();
            HashMap<String, Embed> lstEmbed = new HashMap<String, Embed>();
            try {
                Map unparsedEmbeds = (Map)embeds.get(0);
                Set unparsedKeys = unparsedEmbeds.keySet();
                JsonConverter<Embed> mapper = new JsonConverter<Embed>(Embed.class);
                for (String key : unparsedKeys) {
                    Embed json = null;
                    Object unparsedEmbed = unparsedEmbeds.get(key);
                    json = mapper.convertValue(unparsedEmbed);
                    if (json == null) continue;
                    lstEmbed.put(key, json);
                }
            }
            catch (Exception e) {
                log.error("Parsing embeds", (Throwable)e);
            }
            parsedEmbeds.setLstEmbed(lstEmbed);
            listEmbeds.add(parsedEmbeds);
        }
        this.setEmbeds(listEmbeds);
    }

    public void setEmbeds(List<Embeds> embeds) {
        if (embeds.size() > 0) {
            for (Map.Entry<String, Embed> item : embeds.get(0).getLstEmbed().entrySet()) {
                if (!item.getValue().getType().equals("video")) continue;
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasVideo(true);
                if (item.getValue().getAttributes().size() <= 0 || StringUtils.isEmpty((CharSequence)item.getValue().getAttributes().get(0).getData())) continue;
                this.metadata = this.metadata == null ? new Metadata() : this.metadata;
                this.metadata.setRandname(item.getValue().getAttributes().get(0).getData().substring(item.getValue().getAttributes().get(0).getData().length() - 20));
            }
        }
        this.embeds = embeds;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Taxonomies getTaxonomies() {
        return this.taxonomies;
    }

    public void setTaxonomies(Taxonomies taxonomies) {
        this.taxonomies = taxonomies;
    }

    public Multimedia getMultimedia() {
        return this.multimedia;
    }

    public void setMultimedia(Multimedia multimedia) {
        this.multimedia = multimedia;
    }

    public boolean isExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(boolean externalLink) {
        this.externalLink = externalLink;
    }

    public String toString() {
        return "CanaisAPI [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", slug=" + this.slug + ", title=" + this.title + ", url=" + this.url + ", thumb=" + this.thumb + ", status=" + this.status + ", authorId=" + this.authorId + ", excerpt=" + this.excerpt + ", content=" + this.content + ", pages=" + this.pages + ", totalPages=" + this.totalPages + ", publishDate=" + this.publishDate + ", updateDate=" + this.updateDate + ", blocks=" + this.blocks + ", metadata=" + this.metadata + ", categories=" + this.categories + ", embeds=" + this.embeds + ", tags=" + this.tags + ", taxonomies=" + this.taxonomies + ", multimedia=" + this.multimedia + ", externalLink=" + this.externalLink + "]";
    }
}

