/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.Categories;
import pt.sapo.sapofe.api.MainMenuApiList;
import pt.sapo.sapofe.api.Newspaper;
import pt.sapo.sapofe.api.sapovideos.VideoObj;
import pt.sapo.sapofe.api.tripadvisor.TripAdvResp;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = -3173774769371117459L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private static NewsDb instance = new NewsDb();
    private Map<String, MainMenuApiList> menusBySlug;
    private Map<String, CanaisAPI> blockPagesBySlug;
    private Map<String, CanaisAPI> blockPagesByUrl;
    private Map<String, Categories> categoriesBySlug;
    private Map<String, CanaisAPI> partnersBySlug;
    private Map<String, CanaisAPI> authorsBySlug;
    private Map<String, CanaisAPI> authorsRolesBySlug;
    private Map<String, CanaisAPI> dossiersById;
    private Map<String, CanaisAPI> sponsorsBySlug;
    private Map<String, CanaisAPI> countysById;
    private ArrayList<CanaisAPI> popularArticles;
    private ArrayList<CanaisAPI> latestArticles;
    private Map<String, CanaisAPI> socialBySlug;
    private ArrayList<CanaisAPI> playlists;
    private CanaisAPI mainHighlights;
    private ArrayList<String> articlesOnHP;
    private Map<String, CanaisAPI> itemBySlug;
    private Map<String, TripAdvResp> locationsById;
    private Map<String, TripAdvResp> destinationsById;
    private Map<String, List<CanaisAPI>> mapGenericListCanaisApi;
    private Map<String, List<VideoObj>> mapGenericVideoListApi;
    private Map<String, List<Newspaper>> mapGenericNewspaperApi;
    private Date lastModified = new Date();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NewsDb() {
        String projectName = System.getProperty("project", null);
        String fileName = "./" + (projectName != null ? String.valueOf(projectName) + "-" : "") + "news.db";
        System.out.println("FILENAME: " + fileName);
        File adbFile = new File(fileName);
        if (adbFile.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileInputStream fis = new FileInputStream(adbFile);
                    try {
                        try (ObjectInputStream in = new ObjectInputStream(fis);){
                            NewsDb ard = (NewsDb)in.readObject();
                            this.init(ard.doGetMenus(), ard.doGetBlockPagesBySlug(), ard.doGetCategories(), ard.doGetPartners(), ard.doGetAuthors(), ard.doGetAuthorsRoles(), ard.doGetDossiers(), ard.doGetSponsors(), ard.doGetCountys(), ard.doGetPopularArticles(), ard.doGetLatestArticles(), ard.doGetSocial(), ard.doGetPlaylists(), ard.doGetMainHighlights(), ard.doGetArticlesOnHP(), ard.doGetAllItemBySlug(), ard.doGetAllLocations(), ard.doGetAllDestinations(), ard.doGetMapGenericListCanaisApi(), ard.doGetMapGenericVideoListApi(), ard.doGetMapGenericNewspaperApi());
                        }
                        if (fis == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                Shutdown.now((Throwable)t);
            }
            return;
        }
        this.init(new HashMap<String, MainMenuApiList>(), new HashMap<String, CanaisAPI>(), new HashMap<String, Categories>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new HashMap<String, CanaisAPI>(), new ArrayList<CanaisAPI>(), new ArrayList<CanaisAPI>(), new HashMap<String, CanaisAPI>(), new ArrayList<CanaisAPI>(), new CanaisAPI(), new ArrayList<String>(), new HashMap<String, CanaisAPI>(), new HashMap<String, TripAdvResp>(), new HashMap<String, TripAdvResp>(), new HashMap<String, List<CanaisAPI>>(), new HashMap<String, List<VideoObj>>(), new HashMap<String, List<Newspaper>>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void dump(NewsDb adb) {
        File outFile = new File("./news.db.tmp");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fileOut = new FileOutputStream(outFile);
                try {
                    try (ObjectOutputStream out = new ObjectOutputStream(fileOut);){
                        out.writeObject(adb);
                        out.close();
                        fileOut.close();
                        String projectName = System.getProperty("project", null);
                        String fileName = "./" + (projectName != null ? String.valueOf(projectName) + "-" : "") + "news.db";
                        File dstFile = new File(fileName);
                        Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
                    }
                    if (fileOut == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileOut == null) throw throwable;
                    fileOut.close();
                    throw throwable;
                }
                fileOut.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void build(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, TripAdvResp> _lstLocations, Map<String, TripAdvResp> _lstDestinations, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi) {
        NewsDb adb = new NewsDb(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _lstLocations, _lstDestinations, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        log.info("build(InputStream input)");
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ObjectInputStream in = new ObjectInputStream(input);){
                NewsDb adb = (NewsDb)in.readObject();
                NewsDb.dump(adb);
                instance = adb;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public NewsDb(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, TripAdvResp> _lstLocations, Map<String, TripAdvResp> _lstDestinations, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi) {
        this.init(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _lstLocations, _lstDestinations, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi);
    }

    private void init(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, TripAdvResp> _lstLocations, Map<String, TripAdvResp> _lstDestinations, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi) {
        this.menusBySlug = new HashMap<String, MainMenuApiList>();
        this.blockPagesBySlug = new HashMap<String, CanaisAPI>();
        this.blockPagesByUrl = new HashMap<String, CanaisAPI>();
        this.categoriesBySlug = new HashMap<String, Categories>();
        this.partnersBySlug = new HashMap<String, CanaisAPI>();
        this.authorsBySlug = new HashMap<String, CanaisAPI>();
        this.authorsRolesBySlug = new HashMap<String, CanaisAPI>();
        this.dossiersById = new HashMap<String, CanaisAPI>();
        this.sponsorsBySlug = new HashMap<String, CanaisAPI>();
        this.countysById = new HashMap<String, CanaisAPI>();
        this.popularArticles = new ArrayList();
        this.latestArticles = new ArrayList();
        this.socialBySlug = new HashMap<String, CanaisAPI>();
        this.playlists = new ArrayList();
        this.mainHighlights = new CanaisAPI();
        this.articlesOnHP = new ArrayList();
        this.itemBySlug = new HashMap<String, CanaisAPI>();
        this.locationsById = new HashMap<String, TripAdvResp>();
        this.destinationsById = new HashMap<String, TripAdvResp>();
        this.mapGenericListCanaisApi = new HashMap<String, List<CanaisAPI>>();
        this.mapGenericVideoListApi = new HashMap<String, List<VideoObj>>();
        this.mapGenericNewspaperApi = new HashMap<String, List<Newspaper>>();
        this.fillLookupTables(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _lstLocations, _lstDestinations, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi);
        this.lastModified = new Date();
    }

    private void fillLookupTables(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, TripAdvResp> _lstLocations, Map<String, TripAdvResp> _lstDestinations, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi) {
        this.menusBySlug = _lstMenus;
        this.blockPagesBySlug = _lstBlockPages;
        this.blockPagesByUrl = this.fillBlockPageByUrl(this.blockPagesBySlug);
        this.categoriesBySlug = _lstCategories;
        this.partnersBySlug = _lstPartners;
        this.authorsBySlug = _lstAuthors;
        this.authorsRolesBySlug = _lstAuthorsRoles;
        this.dossiersById = _lstDossiers;
        this.sponsorsBySlug = _lstSponsors;
        this.countysById = _lstCountys;
        this.popularArticles = _lstPopularArticles;
        this.latestArticles = _lstLatestArticles;
        this.socialBySlug = _lstSocial;
        this.playlists = _lstPlaylists;
        this.mainHighlights = _mainHighlights;
        this.articlesOnHP = _lstArticlesOnHP;
        this.itemBySlug = _lstPagesBySlug;
        this.locationsById = _lstLocations;
        this.destinationsById = _lstDestinations;
        this.mapGenericListCanaisApi = _mapGenericListCanaisApi;
        this.mapGenericVideoListApi = _mapGenericVideoListApi;
        this.mapGenericNewspaperApi = _mapGenericNewspaperApi;
    }

    private Map<String, CanaisAPI> fillBlockPageByUrl(Map<String, CanaisAPI> _blockPagesBySlug) {
        HashMap<String, CanaisAPI> _blockPagesByUrl = new HashMap<String, CanaisAPI>();
        for (Map.Entry<String, CanaisAPI> entry : _blockPagesBySlug.entrySet()) {
            CanaisAPI _blockPage = entry.getValue();
            if (_blockPage == null || StringUtils.isEmpty((CharSequence)_blockPage.getUrl())) continue;
            _blockPagesByUrl.put(_blockPage.getUrl(), _blockPage);
        }
        return _blockPagesByUrl;
    }

    public static final Map<String, MainMenuApiList> getAllMenus() {
        return instance.doGetMenus();
    }

    public static final Map<String, CanaisAPI> getAllBlockPagesBySlug() {
        return instance.doGetBlockPagesBySlug();
    }

    public static final Map<String, Categories> getCategories() {
        return instance.doGetCategories();
    }

    public static final Map<String, CanaisAPI> getPartners() {
        return instance.doGetPartners();
    }

    public static final Map<String, CanaisAPI> getAuthors() {
        return instance.doGetAuthors();
    }

    public static final Map<String, CanaisAPI> getAuthorsRoles() {
        return instance.doGetAuthorsRoles();
    }

    public static final Map<String, CanaisAPI> getDossiers() {
        return instance.doGetDossiers();
    }

    public static final Map<String, CanaisAPI> getSponsors() {
        return instance.doGetSponsors();
    }

    public static final Map<String, CanaisAPI> getCountys() {
        return instance.doGetCountys();
    }

    public static final ArrayList<CanaisAPI> getPopularArticles() {
        return instance.doGetPopularArticles();
    }

    public static final ArrayList<CanaisAPI> getLatestArticles() {
        return instance.doGetLatestArticles();
    }

    public static final ArrayList<CanaisAPI> getPlaylists() {
        return instance.doGetPlaylists();
    }

    public static final CanaisAPI getMainHighlights() {
        return instance.doGetMainHighlights();
    }

    public static final ArrayList<String> getArticlesOnHP() {
        return instance.doGetArticlesOnHP();
    }

    public static final Map<String, CanaisAPI> getSocial() {
        return instance.doGetSocial();
    }

    public static final CanaisAPI getItemBySlug(String slug) {
        return instance.doGetItemBySlug(slug);
    }

    public static final Map<String, CanaisAPI> getAllItemBySlug() {
        return instance.doGetAllItemBySlug();
    }

    public static final TripAdvResp getLocationById(String id) {
        return instance.doGetLocationById(id);
    }

    public static final Map<String, TripAdvResp> getAllLocations() {
        return instance.doGetAllLocations();
    }

    public static final TripAdvResp getDestinationById(String id) {
        return instance.doGetDestinationById(id);
    }

    public static final Map<String, TripAdvResp> getAllDestinations() {
        return instance.doGetAllDestinations();
    }

    public static final Map<String, List<CanaisAPI>> getMapGenericListCanaisApi() {
        return instance.doGetMapGenericListCanaisApi();
    }

    public static final Map<String, List<VideoObj>> getMapGenericVideoListApi() {
        return instance.doGetMapGenericVideoListApi();
    }

    public static final Map<String, List<Newspaper>> getMapGenericNewspaperApi() {
        return instance.doGetMapGenericNewspaperApi();
    }

    private Map<String, MainMenuApiList> doGetMenus() {
        return this.menusBySlug;
    }

    private Map<String, CanaisAPI> doGetBlockPagesBySlug() {
        return this.blockPagesBySlug;
    }

    private Map<String, Categories> doGetCategories() {
        return this.categoriesBySlug;
    }

    private Map<String, CanaisAPI> doGetPartners() {
        return this.partnersBySlug;
    }

    private Map<String, CanaisAPI> doGetAuthors() {
        return this.authorsBySlug;
    }

    private Map<String, CanaisAPI> doGetAuthorsRoles() {
        return this.authorsRolesBySlug;
    }

    private Map<String, CanaisAPI> doGetDossiers() {
        return this.dossiersById;
    }

    private Map<String, CanaisAPI> doGetSponsors() {
        return this.sponsorsBySlug;
    }

    private Map<String, CanaisAPI> doGetCountys() {
        return this.countysById;
    }

    private ArrayList<CanaisAPI> doGetPopularArticles() {
        return this.popularArticles;
    }

    private ArrayList<CanaisAPI> doGetLatestArticles() {
        return this.latestArticles;
    }

    private Map<String, CanaisAPI> doGetSocial() {
        return this.socialBySlug;
    }

    private ArrayList<CanaisAPI> doGetPlaylists() {
        return this.playlists;
    }

    private CanaisAPI doGetMainHighlights() {
        return this.mainHighlights;
    }

    private ArrayList<String> doGetArticlesOnHP() {
        return this.articlesOnHP;
    }

    private Map<String, CanaisAPI> doGetAllItemBySlug() {
        return this.itemBySlug;
    }

    private CanaisAPI doGetItemBySlug(String slug) {
        return this.itemBySlug.get(slug);
    }

    private Map<String, TripAdvResp> doGetAllLocations() {
        return this.locationsById;
    }

    private TripAdvResp doGetLocationById(String id) {
        return this.locationsById.get(id);
    }

    private TripAdvResp doGetDestinationById(String id) {
        return this.destinationsById.get(id);
    }

    private Map<String, TripAdvResp> doGetAllDestinations() {
        return this.destinationsById;
    }

    private Map<String, List<CanaisAPI>> doGetMapGenericListCanaisApi() {
        return this.mapGenericListCanaisApi;
    }

    private Map<String, List<VideoObj>> doGetMapGenericVideoListApi() {
        return this.mapGenericVideoListApi;
    }

    private Map<String, List<Newspaper>> doGetMapGenericNewspaperApi() {
        return this.mapGenericNewspaperApi;
    }

    public static final Date getLastModified() {
        return instance.doGetLastModified();
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static CanaisAPI getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }

    public static Map<String, CanaisAPI> getBlockPages() {
        return NewsDb.instance.blockPagesBySlug;
    }

    public static CanaisAPI getBlockPageBySlug(String slug) {
        return NewsDb.instance.blockPagesBySlug.get(slug);
    }

    public static CanaisAPI getBlockPageByUrl(String url) {
        return NewsDb.instance.blockPagesByUrl.get(url);
    }

    public static Map<String, CanaisAPI> getBrands() {
        return new HashMap<String, CanaisAPI>();
    }
}

